# 画面設計書 78-アセットプロパティ画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるアセットプロパティ画面（assets/properties.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、アセット（ファイル）の詳細プロパティ情報を表示するためのAjaxダイアログ画面です。

**業務上の目的・背景**：アップロードされたファイルの詳細情報（ファイル名、サイズ、MIMEタイプ、アップロード日時など）を確認する必要がある場合に使用します。ファイルの技術的な情報を参照することで、ファイルの整理や問題診断に役立てます。

**画面へのアクセス方法**：アセット管理画面（/admin/assets/）で対象アセットの「Properties」ボタンをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. プロパティ情報の確認 - ファイルの各種プロパティを閲覧
2. ダイアログを閉じる - 「Close」ボタンでダイアログを閉じる

**画面遷移**：アセット管理画面からAjaxダイアログとして呼び出されます。表示専用画面のため、画面遷移は発生しません。

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | アセットプロパティの表示 |

## 画面種別

詳細（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/assets/properties/asset/{assetID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: propertiesAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| なし | - | - | - | - | 本画面は表示専用 | - |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| File Name | テキスト | ファイル名（拡張子付き） |
| MIME Type | テキスト | ファイルのMIMEタイプ |
| File Size | テキスト | ファイルサイズ（バイト単位） |
| Date Uploaded | テキスト | アップロード日時 |
| Last Modified | テキスト | 最終更新日時 |
| Close | Button | ダイアログを閉じるボタン |

## イベント仕様

### 1-Closeボタン押下

1. `dijit.byId('ajaxDialog').hide()` を呼び出し
2. ダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets | SELECT | アセット情報を取得 |

### テーブル別更新項目詳細

本画面ではデータ更新を行いません（参照のみ）。

## メッセージ仕様

本画面にはメッセージ表示機能はありません。

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |

## 備考

- 本画面はDojo Toolkitのdijit.Dialogとして表示されるAjax画面です
- レイアウトは無効化されており、ダイアログコンテンツのみがレンダリングされます
- 表示専用画面のため、データの変更は行いません
- MakeDate()ビューヘルパーで日付フォーマットを行います
- FormatBytes()ビューヘルパーでファイルサイズを人間が読みやすい形式に変換します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アセットのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | propertiesAction()（1013-1038行目）でのデータ取得処理を確認 |

**読解のコツ**: assetsテーブルの各カラム（asset_name, asset_extension, asset_mime, asset_size, asset_date, asset_modified）がどのようにビューに渡されるかを理解します。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | propertiesAction()がエントリーポイント |

**主要処理フロー（propertiesAction）**:
1. **1015行目**: 権限チェック（fassets）
2. **1017行目**: レイアウト無効化
3. **1019行目**: URLパラメータからアセットIDを取得
4. **1023-1028行目**: assetsテーブルからアセット情報取得
5. **1031行目**: ビューにアセット情報を渡す

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | properties.phtml | `application/modules/admin/views/scripts/assets/properties.phtml` | プロパティ表示とビューヘルパーの使用を確認 |

**主要処理フロー（properties.phtml）**:
- **12行目**: ファイル名（asset_name + . + asset_extension）表示
- **16行目**: MIMEタイプ（asset_mime）表示
- **20行目**: ファイルサイズ（asset_size）表示（FormatBytes()使用）
- **24行目**: アップロード日時（asset_date）表示（MakeDate()使用）
- **28行目**: 最終更新日時（asset_modified）表示（MakeDate()使用）
- **32-38行目**: Closeボタン

### プログラム呼び出し階層図

```
[ブラウザ] Ajaxリクエスト（/admin/assets/properties/asset/{assetID}/）
    │
    ├─ AssetsController::propertiesAction()
    │      │
    │      ├─ ACL権限チェック（fassets）
    │      │
    │      ├─ レイアウト無効化
    │      │
    │      └─ DB: SELECT assets WHERE asset_id = {assetID}
    │
    └─ properties.phtml レンダリング
           │
           ├─ ファイル名表示
           ├─ MIMEタイプ表示
           ├─ ファイルサイズ表示（FormatBytes()）
           ├─ アップロード日時表示（MakeDate()）
           └─ 最終更新日時表示（MakeDate()）
```

### データフロー図

```
[入力]               [処理]                    [出力]

asset (ID) ────────▶ propertiesAction()
                         │
                         └─ DB: SELECT assets ──▶ properties.phtml
                               │
                               ├─ asset_name        ▶ File Name
                               ├─ asset_extension
                               ├─ asset_mime        ▶ MIME Type
                               ├─ asset_size        ▶ File Size
                               ├─ asset_date        ▶ Date Uploaded
                               └─ asset_modified    ▶ Last Modified
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | propertiesアクションの実行 |
| properties.phtml | `application/modules/admin/views/scripts/assets/properties.phtml` | テンプレート | プロパティ画面の表示 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | テンプレート | 親画面（アセット管理画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog()関数の定義 |
