# 画面設計書 79-フォルダ画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるフォルダ画面（assets/folder.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、アセット管理システムのフォルダ名を編集するためのAjaxダイアログ画面です。

**業務上の目的・背景**：アセットを整理するためのフォルダの名前を変更する必要がある場合に使用します。フォルダの階層構造（親フォルダ）は変更せず、フォルダ名のみを編集できます。これにより、ファイル整理や命名規則の統一などの運用ニーズに対応します。

**画面へのアクセス方法**：アセット管理画面（/admin/assets/）で対象フォルダの「Edit」ボタンをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. フォルダ名の確認 - 現在のフォルダ名を確認
2. フォルダ名の編集 - 新しいフォルダ名を入力
3. 保存実行 - 「Submit」ボタンで変更を保存
4. キャンセル - 「Cancel」ボタンでダイアログを閉じる

**画面遷移**：アセット管理画面からAjaxダイアログとして呼び出されます。保存成功後は画面をリロードしてダイアログを閉じます。

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限および「ffolderedit」（フォルダ編集）権限の両方が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | フォルダ情報の編集 |
| 61 | アクセス制御 | 補助機能 | フォルダ管理の権限チェック |

## 画面種別

編集（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/assets/folder/folder/{folderID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: folderAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| フォルダID | folder | integer | 必須 | 入力（URL） | 編集対象フォルダのID | URLパラメータから取得 |
| フォルダ名 | foldertitle | string | 必須 | 入出力 | フォルダの表示名 | NotEmpty |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Folder Name | ValidationTextBox | フォルダ名入力フィールド |
| Submit | Button | 保存ボタン |
| Cancel | Button | キャンセルボタン |

## イベント仕様

### 1-Submitボタン押下

1. フォームバリデーションを実行
2. `doDialog('/admin/assets/folder/folder/{folderID}/','foldereditForm','Edit Folder')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. 入力値が有効かつ重複がない場合、assets_foldersテーブルを更新
5. 成功時、「Folder Edited」メッセージと「Close」ボタンを表示
6. 「Close」ボタン押下で画面リロードしてダイアログを閉じる

### 2-Cancelボタン押下

1. `dijit.byId('ajaxDialog').hide()` を呼び出し
2. ダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets_folders | SELECT | フォルダ情報を取得 |
| Submitボタン押下 | assets_folders | SELECT | 同名フォルダ重複チェック |
| Submitボタン押下 | assets_folders | UPDATE | フォルダ名を更新 |

### テーブル別更新項目詳細

#### assets_folders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | folder_name | 入力されたフォルダ名 | foldertitle パラメータの値 |
| UPDATE | folder_modify | NOW() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Folder Edited | フォルダ編集成功時 |
| MSG002 | エラー | Folder name is required | フォルダ名が未入力 |
| MSG003 | エラー | A folder with this name already exists in this folder | 同一親フォルダに同名フォルダが存在 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 同名フォルダ重複 | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 本画面はDojo Toolkitのdijit.Dialogとして表示されるAjax画面です
- レイアウトは無効化されており、ダイアログコンテンツのみがレンダリングされます
- 親フォルダ（folder_parent）は変更できません
- 同一親フォルダ内での重複チェックは、folder_parent、folder_id（自身を除く）、folder_name条件で行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フォルダのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | folderAction()（808-915行目）でのデータ取得・更新処理を確認 |

**読解のコツ**: assets_foldersテーブルのfolder_parent列で階層構造が管理されています。フォルダ名（folder_name）のみが編集対象です。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | folderAction()がエントリーポイント |

**主要処理フロー（folderAction）**:
1. **810行目**: 権限チェック（fassets および ffolderedit）
2. **812行目**: レイアウト無効化
3. **814行目**: URLパラメータからフォルダIDを取得
4. **818-824行目**: フォルダ情報の取得
5. **828行目**: ビューに現在のフォルダ名を設定
6. **830行目**: POSTリクエスト判定
7. **836-842行目**: バリデータ定義
8. **844行目**: 入力検証実行
9. **848-856行目**: 同名フォルダ重複チェック
10. **864-873行目**: 検証成功時、assets_foldersテーブルを更新

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | folder.phtml | `application/modules/admin/views/scripts/assets/folder.phtml` | フォーム構造とDojo widgetの設定を確認 |

**主要処理フロー（folder.phtml）**:
- **9行目**: posted=='N'でフォーム表示判定
- **14-29行目**: フォルダ名入力ValidationTextBox
- **33-44行目**: SubmitボタンとCancelボタン

### プログラム呼び出し階層図

```
[ブラウザ] Ajaxリクエスト（/admin/assets/folder/folder/{folderID}/）
    │
    ├─ AssetsController::folderAction()
    │      │
    │      ├─ ACL権限チェック（fassets, ffolderedit）
    │      │
    │      ├─ レイアウト無効化
    │      │
    │      ├─ DB: SELECT assets_folders WHERE folder_id = {folderID}
    │      │
    │      ├─ [POST時] バリデーション
    │      │
    │      ├─ [POST時] 重複チェック
    │      │      └─ DB: SELECT assets_folders
    │      │            WHERE folder_parent = {parent}
    │      │            AND folder_id != {folderID}
    │      │            AND folder_name = {foldertitle}
    │      │
    │      └─ [POST時] DB: UPDATE assets_folders
    │             └─ folder_name, folder_modify
    │
    └─ folder.phtml レンダリング
           │
           └─ フォルダ名入力フィールド
```

### データフロー図

```
[入力]               [処理]                    [出力]

folder (ID) ───────▶ folderAction()
                         │
                         ├─ DB: SELECT ───────▶ 画面表示
                         │   assets_folders      (フォルダ名)
[POST]
foldertitle ───────▶     │
                         ├─ バリデーション
                         │
                         ├─ 重複チェック
                         │
                         └─ DB: UPDATE ───────▶ 結果表示
                            assets_folders       "Folder Edited"
                               │
                               ├─ folder_name
                               └─ folder_modify
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | folderアクションの実行 |
| folder.phtml | `application/modules/admin/views/scripts/assets/folder.phtml` | テンプレート | フォルダ編集ダイアログの表示 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | テンプレート | 親画面（アセット管理画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog()関数の定義 |
