# 画面設計書 8-アカウント有効化画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるアカウント有効化画面の設計仕様を定義する。メール認証によるアカウント有効化処理を実行し、ユーザーをアクティブ状態に遷移させる。

### 本画面の処理概要

**業務上の目的・背景**：アカウント有効化画面は、ユーザー登録時に送信された有効化メール内のリンクから遷移し、メールアドレスの所有確認を完了する機能を提供する。これにより、不正なメールアドレスでの登録を防止し、確実な本人確認を実現する。メール認証によるセキュリティ確保という業務課題を解決する。

**画面へのアクセス方法**：ユーザー登録後に送信される有効化メール内のリンクからアクセス。URLは`/auth/activate/id/{user_id}/key/{user_key}/`。

**主要な操作・処理内容**：
1. URLパラメータ（id, key）の検証
2. 該当ユーザーの存在確認（inactive状態のみ）
3. ユーザーステータスを'active'に更新
4. アカウント有効化完了メールの送信
5. ログイン画面へリダイレクト（method=activated付き）

**画面遷移**：
- 遷移元：有効化メール内のリンク
- 遷移先：ログイン画面（method=activatedパラメータ付き）

**権限による表示制御**：
- 既にログイン済みの場合、ホーム画面へリダイレクト
- 未認証ユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | ユーザー新規作成 | 主機能 | アカウントの有効化処理を完了 |

## 画面種別

処理実行（自動リダイレクト型）

## URL/ルーティング

- URL: `/auth/activate/id/{user_id}/key/{user_key}/`
- コントローラー: `AuthController`
- アクション: `activateAction`
- モジュール: `default`
- HTTPメソッド: GET
- URLパラメータ:
  - `id`: ユーザーID
  - `key`: 有効化キー（MD5(email + password)）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| id | URL | int | はい | ユーザーID |
| key | URL | string | はい | 有効化キー |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| posted | 出力 | string | - | 処理完了フラグ（'Y'/'N'） |
| messages | 出力 | array | - | エラーメッセージ |
| userArray | 出力 | array | - | ユーザー情報（成功時） |

## 表示項目

### メイン表示

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| Account Activation | 常時 | 画面タイトル |
| エラーメッセージ | 有効化失敗時 | RenderMessages()で表示 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| Not a Member? | 新規登録案内（内容省略） |

## イベント仕様

### 1-有効化処理実行

画面アクセス時に自動的に有効化処理が実行される。

- 処理フロー:
  1. URLパラメータ（id, key）の存在確認
  2. users + users_profilesから該当ユーザー取得（status='inactive'）
  3. ユーザー存在確認
  4. user_statusを'active'に更新
  5. 有効化完了メール送信
  6. ログイン画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 有効化処理 | users | SELECT | ユーザー情報を取得（id, key, status条件） |
| 有効化処理 | users_profiles | SELECT | プロファイル情報を取得（JOINで結合） |
| 有効化処理 | users | UPDATE | ステータスを'active'に更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | user_id = {id} AND user_key = {key} AND user_status = 'inactive' | JOIN users_profiles |
| UPDATE | user_status | 'active' | 有効化完了 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | Invalid Credentials - the credentials you supplied cannot be matched to an account awaiting activation | id/key不一致、またはパラメータ不足時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| id/keyパラメータ不足 | エラーメッセージ表示、posted='N' |
| ユーザー不存在 | エラーメッセージ表示、posted='N' |
| 既に有効化済み | ユーザー不存在として処理（status='inactive'条件のため） |
| メール送信失敗 | リダイレクトは実行（例外処理なし） |

## 備考

- 有効化成功時、自動的にログイン画面へリダイレクト
- リダイレクト時のURLは`/auth/login?method=activated`
- ログイン画面で「Account Activated」メッセージが表示される
- 有効化完了メールにはログインURL、設定URL、パスワードリセットURLが含まれる
- 本画面は基本的に一時的な表示で、すぐにリダイレクトされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、有効化に関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブルのuser_id, user_key, user_statusカラム |
| 1-2 | database.sql | `database.sql` | users_profilesテーブルとのリレーション |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | activateAction()メソッド（463-532行目） |

**主要処理フロー**:
1. **465-466行目**: URLパラメータ（id, key）取得
2. **468行目**: id/key両方存在確認
3. **473-479行目**: SELECT users JOIN users_profiles（id, key, status='inactive'）
4. **484行目**: ユーザー存在確認（count > 0）
5. **489-491行目**: user_status = 'active'に更新データ準備
6. **494行目**: UPDATE実行
7. **496-511行目**: 有効化完了メール送信
8. **513行目**: posted = 'Y'
9. **515行目**: ログイン画面へリダイレクト（method=activated）
10. **517-521行目**: ユーザー不存在時のエラー設定

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | activate.phtml | `application/modules/default/views/scripts/auth/activate.phtml` | メインテンプレート。エラーメッセージ表示 |

**主要処理フロー**:
- **31行目**: RenderMessages()でエラーメッセージ表示
- 成功時は即座にリダイレクトされるため、成功メッセージは表示されない

### プログラム呼び出し階層図

```
HTTP Request (/auth/activate/id/123/key/abc...)
    |
    +-- AuthController::preDispatch()
    |       |
    |       +-- 認証状態チェック
    |       +-- [認証済み] ホームへリダイレクト
    |
    +-- AuthController::activateAction()
            |
            +-- URLパラメータ取得 (id, key)
            |
            +-- [id && key 存在]
            |       |
            |       +-- SELECT users JOIN users_profiles
            |       |       WHERE user_id = {id}
            |       |       AND user_key = {key}
            |       |       AND user_status = 'inactive'
            |       |
            |       +-- [ユーザー存在]
            |       |       |
            |       |       +-- UPDATE users SET user_status = 'active'
            |       |       +-- Zend_Mail::send() (有効化完了メール)
            |       |       +-- posted = 'Y'
            |       |       +-- リダイレクト → /auth/login?method=activated
            |       |
            |       +-- [ユーザー不存在]
            |               +-- posted = 'N'
            |               +-- エラーメッセージ設定
            |
            +-- [id || key 不存在]
                    +-- posted = 'N'
                    +-- エラーメッセージ設定
```

### データフロー図

```
[入力]               [処理]                    [出力]

有効化メール    ───▶ AuthController       ───▶ 成功: リダイレクト
リンククリック        ::activateAction()        (/auth/login?method=activated)
  |                        |                        |
  +-- id              パラメータ検証               +── 有効化完了メール
  +-- key                  |
                      DB検索                  ───▶ 失敗: エラー表示
                           |                        (activate.phtml)
                           ▼
                      UPDATE users
                      (status='active')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/default/controllers/AuthController.php` | ソース | 認証関連のコントローラー |
| activate.phtml | `application/modules/default/views/scripts/auth/activate.phtml` | テンプレート | アカウント有効化画面のメインビュー |
| database.sql | `database.sql` | スキーマ | users, users_profilesテーブル定義 |
