# 画面設計書 80-フォルダ新規作成画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるフォルダ新規作成画面（assets/foldernew.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、アセット管理システムに新しいフォルダを作成するためのAjaxダイアログ画面です。

**業務上の目的・背景**：アセットを整理するためのフォルダ構造を構築する必要がある場合に使用します。現在表示中のフォルダ内に新しいサブフォルダを作成できます。これにより、カテゴリ別やプロジェクト別など、ユーザーのニーズに合わせたファイル整理が可能になります。

**画面へのアクセス方法**：アセット管理画面（/admin/assets/）の「New Folder」ボタンをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. フォルダ名の入力 - 新しいフォルダの名前を入力
2. 作成実行 - 「Submit」ボタンでフォルダを作成
3. キャンセル - 「Cancel」ボタンでダイアログを閉じる

**画面遷移**：アセット管理画面からAjaxダイアログとして呼び出されます。作成成功後は画面をリロードしてダイアログを閉じます。

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限および「ffoldernew」（フォルダ新規作成）権限の両方が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | フォルダの新規作成 |
| 61 | アクセス制御 | 補助機能 | フォルダ管理の権限チェック |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/assets/foldernew/parent/{parentFolderID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: foldernewAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| 親フォルダID | parent | integer | 必須 | 入力（URL） | 親フォルダのID（0=ルート） | URLパラメータから取得 |
| フォルダ名 | foldertitle | string | 必須 | 入力 | 新しいフォルダの名前 | NotEmpty |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Folder Name | ValidationTextBox | フォルダ名入力フィールド |
| Submit | Button | 作成ボタン |
| Cancel | Button | キャンセルボタン |

## イベント仕様

### 1-Submitボタン押下

1. フォームバリデーションを実行
2. `doDialog('/admin/assets/foldernew/parent/{parentFolderID}/','foldernewForm','New Folder')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. 入力値が有効かつ重複がない場合、assets_foldersテーブルに新規レコードを作成
5. 成功時、「Folder Created」メッセージと「Close」ボタンを表示
6. 「Close」ボタン押下で画面リロードしてダイアログを閉じる

### 2-Cancelボタン押下

1. `dijit.byId('ajaxDialog').hide()` を呼び出し
2. ダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Submitボタン押下 | assets_folders | SELECT | 同名フォルダ重複チェック |
| Submitボタン押下 | assets_folders | INSERT | 新規フォルダレコードを作成 |

### テーブル別更新項目詳細

#### assets_folders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | folder_parent | URLパラメータの親フォルダID | parent パラメータの値 |
| INSERT | folder_name | 入力されたフォルダ名 | foldertitle パラメータの値 |
| INSERT | folder_date | NOW() | 作成日時 |
| INSERT | folder_modify | NOW() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Folder Created | フォルダ作成成功時 |
| MSG002 | エラー | Folder name is required | フォルダ名が未入力 |
| MSG003 | エラー | A folder with this name already exists in this folder | 同一親フォルダに同名フォルダが存在 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 同名フォルダ重複 | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 本画面はDojo Toolkitのdijit.Dialogとして表示されるAjax画面です
- レイアウトは無効化されており、ダイアログコンテンツのみがレンダリングされます
- 親フォルダIDが0の場合はルートフォルダ直下に作成されます
- 同一親フォルダ内での重複チェックは、folder_parent、folder_name条件で行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フォルダのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | foldernewAction()（631-727行目）でのデータ挿入処理を確認 |

**読解のコツ**: assets_foldersテーブルのfolder_parent列で階層構造が管理されています。新規フォルダはparentパラメータで指定されたフォルダの子として作成されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | foldernewAction()がエントリーポイント |

**主要処理フロー（foldernewAction）**:
1. **633行目**: 権限チェック（fassets および ffoldernew）
2. **635行目**: レイアウト無効化
3. **637行目**: URLパラメータから親フォルダIDを取得
4. **639行目**: POSTリクエスト判定
5. **645-651行目**: バリデータ定義
6. **653行目**: 入力検証実行
7. **657-666行目**: 同名フォルダ重複チェック
8. **674-685行目**: 検証成功時、assets_foldersテーブルに新規レコード作成

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | foldernew.phtml | `application/modules/admin/views/scripts/assets/foldernew.phtml` | フォーム構造とDojo widgetの設定を確認 |

**主要処理フロー（foldernew.phtml）**:
- **9行目**: posted=='N'でフォーム表示判定
- **14-29行目**: フォルダ名入力ValidationTextBox
- **33-44行目**: SubmitボタンとCancelボタン

### プログラム呼び出し階層図

```
[ブラウザ] Ajaxリクエスト（/admin/assets/foldernew/parent/{parentFolderID}/）
    │
    ├─ AssetsController::foldernewAction()
    │      │
    │      ├─ ACL権限チェック（fassets, ffoldernew）
    │      │
    │      ├─ レイアウト無効化
    │      │
    │      ├─ URLパラメータから親フォルダIDを取得
    │      │
    │      ├─ [POST時] バリデーション
    │      │
    │      ├─ [POST時] 重複チェック
    │      │      └─ DB: SELECT assets_folders
    │      │            WHERE folder_parent = {parentFolderID}
    │      │            AND folder_name = {foldertitle}
    │      │
    │      └─ [POST時] DB: INSERT assets_folders
    │             └─ folder_parent, folder_name, folder_date, folder_modify
    │
    └─ foldernew.phtml レンダリング
           │
           └─ フォルダ名入力フィールド
```

### データフロー図

```
[入力]               [処理]                    [出力]

parent (ID) ───────▶ foldernewAction()
                         │
                         └─ フォーム表示 ─────▶ 画面表示
                                                (フォルダ名入力)
[POST]
foldertitle ───────▶     │
                         ├─ バリデーション
                         │
                         ├─ 重複チェック
                         │      └─ DB: SELECT assets_folders
                         │
                         └─ DB: INSERT ───────▶ 結果表示
                            assets_folders       "Folder Created"
                               │
                               ├─ folder_parent
                               ├─ folder_name
                               ├─ folder_date
                               └─ folder_modify
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | foldernewアクションの実行 |
| foldernew.phtml | `application/modules/admin/views/scripts/assets/foldernew.phtml` | テンプレート | フォルダ新規作成ダイアログの表示 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | テンプレート | 親画面（アセット管理画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog()、getDialog()関数の定義 |
