# 画面設計書 81-フォルダプロパティ画面

## 概要

本ドキュメントは、Legacy CMS管理画面のフォルダプロパティ画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、アセット管理機能においてフォルダのプロパティ情報を表示し、フォルダ名の編集画面への遷移を提供するダイアログ画面です。

**業務上の目的・背景**：CMSでアップロードされたファイル・画像アセットはフォルダで整理されています。管理者がフォルダの作成日時、更新日時などのメタ情報を確認する必要がある場合に、このプロパティ画面を使用します。フォルダの管理情報を一目で確認でき、必要に応じてフォルダ名の編集画面へ遷移することで、アセット管理業務を効率化します。

**画面へのアクセス方法**：アセット管理画面（フォルダビュー）でフォルダを右クリックし、コンテキストメニューから「Properties」を選択することで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. フォルダ名（Title）の表示
2. フォルダ作成日時（Created）の表示
3. フォルダ更新日時（Modified）の表示
4. 「Edit」ボタンによるフォルダ編集ダイアログへの遷移
5. 「Close」ボタンによるダイアログの閉じる処理

**画面遷移**：
- 遷移元：アセット管理画面（フォルダビュー）のコンテキストメニュー
- 遷移先：フォルダ編集画面（フォルダ画面）

**権限による表示制御**：fassets権限を持つユーザーのみがこの画面にアクセスできます。権限がない場合は権限エラー画面へ転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | アセット編集 | 主機能 | フォルダのプロパティを編集 |
| 63 | 入力検証 | 補助機能 | プロパティフォームのバリデーション |

## 画面種別

詳細（ダイアログ）

## URL/ルーティング

```
/admin/assets/folderproperties/folder/{folder_id}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| folder | フォルダID | Yes |

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| フォルダID | folder | integer | Yes | 表示対象のフォルダを識別するID |

## 表示項目

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| フォルダ名 | Title | folder_name | テキスト | フォルダの名前 |
| 作成日時 | Created | folder_date | 日時 | jS F Y g:i:sa形式で表示 |
| 更新日時 | Modified | folder_modify | 日時 | jS F Y g:i:sa形式で表示 |

## イベント仕様

### 1-Edit（編集）ボタン押下

**トリガー**：「Edit」ボタンをクリック

**処理内容**：
1. getDialog関数を呼び出し、フォルダ編集画面をAjaxダイアログとして表示
2. 遷移先URL：`/admin/assets/folder/folder/{folder_id}/`
3. ダイアログタイトル：「Edit Folder」

**画面遷移**：フォルダ編集画面（folder.phtml）がダイアログ内に表示される

### 2-Close（閉じる）ボタン押下

**トリガー**：「Close」ボタンをクリック

**処理内容**：
1. dijit.byId('ajaxDialog').hide()を実行
2. 現在のダイアログを非表示にする

**画面遷移**：ダイアログが閉じ、元のアセット管理画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets_folders | SELECT | フォルダ情報の取得 |

### テーブル別更新項目詳細

#### assets_folders（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | folder_id | リクエストパラメータのfolderと一致 | 主キー |
| SELECT | folder_name | - | フォルダ名表示用 |
| SELECT | folder_date | - | 作成日時表示用 |
| SELECT | folder_modify | - | 更新日時表示用 |

## メッセージ仕様

本画面は読み取り専用の表示画面のため、メッセージは表示されません。

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| fassets権限がない | 権限エラー画面へ転送 | privileges.phtml |
| フォルダが存在しない | 配列アクセスエラー | エラー画面 |

## 備考

- 本画面はAjaxダイアログとして表示されるため、レイアウトは無効化されています
- Dojo Toolkitのdijit.form.Buttonウィジェットを使用しています
- 日付表示にはビューヘルパー`MakeDate`を使用し、「jS F Y g:i:sa」形式（例：1st January 2024 9:30:00am）で表示します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォルダプロパティ画面で扱うデータは`assets_folders`テーブルから取得されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベーススキーマ | `application/configs/schema.sql`（存在する場合） | assets_foldersテーブルの構造を確認 |

**読解のコツ**: Zend Frameworkでは、テーブル構造はモデルクラスまたはコントローラー内のSQLクエリから推測できます。

#### Step 2: エントリーポイントを理解する

コントローラーのfolderpropertiesActionが処理の起点です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | folderpropertiesAction（920-945行目）の処理フローを確認 |

**主要処理フロー**:
1. **922行目**: ACLによる権限チェック（fassets権限）
2. **924行目**: レイアウト無効化
3. **926行目**: folderパラメータの取得
4. **928-936行目**: assets_foldersテーブルからフォルダ情報を取得
5. **938行目**: ビューに$folderArrayをセット

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | folderproperties.phtml | `application/modules/admin/views/scripts/assets/folderproperties.phtml` | プロパティ表示テーブルとボタンの構造を確認 |

**主要処理フロー**:
- **9-22行目**: プロパティ表示用テーブル（Title, Created, Modified）
- **25-30行目**: Editボタン（フォルダ編集ダイアログへの遷移）
- **31-36行目**: Closeボタン（ダイアログを閉じる）

### プログラム呼び出し階層図

```
[Ajaxリクエスト: /admin/assets/folderproperties/folder/{id}/]
    │
    ├─ AssetsController::folderpropertiesAction()
    │      ├─ ACL権限チェック（fassets）
    │      ├─ Zend_Db_Select（assets_folders取得）
    │      └─ View変数セット（$folderArray）
    │
    └─ folderproperties.phtml
           ├─ プロパティテーブル表示
           ├─ MakeDateビューヘルパー
           ├─ Editボタン → getDialog('/admin/assets/folder/...')
           └─ Closeボタン → dijit.byId('ajaxDialog').hide()
```

### データフロー図

```
[入力]               [処理]                    [出力]

folder_id ───────▶ AssetsController      ───▶ folderArray
(URLパラメータ)      ::folderpropertiesAction()    (ビュー変数)
                          │
                          ▼
                   assets_folders
                   テーブル参照
                          │
                          ▼
                   folderproperties.phtml ───▶ HTMLダイアログ
                   (プロパティ表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | フォルダプロパティアクションの処理 |
| folderproperties.phtml | `application/modules/admin/views/scripts/assets/folderproperties.phtml` | ビュー | プロパティ表示テンプレート |
| folder.phtml | `application/modules/admin/views/scripts/assets/folder.phtml` | ビュー | フォルダ編集画面（遷移先） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog関数等の共通機能 |
| Admin.php | `application/modules/admin/controllers/AdminController.php` | コントローラー | 基底クラス（ACL等） |
