# 画面設計書 82-画像プレビュー画面

## 概要

本ドキュメントは、Legacy CMS管理画面の画像プレビュー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、画像挿入画面（No.83）から呼び出され、画像のリサイズプレビューを表示する部分画面です。指定されたサイズとリサイズタイプに基づいて、画像がどのように表示されるかをリアルタイムでプレビューします。

**業務上の目的・背景**：記事やページにコンテンツを編集する際、WYSIWYGエディタに画像を挿入することがあります。その際、画像のサイズを調整する必要がありますが、実際に挿入する前に結果を確認したいという要望があります。本画面は、リサイズ設定を変更しながら視覚的に確認できる機能を提供し、コンテンツ作成の効率化を支援します。

**画面へのアクセス方法**：画像挿入画面（imageinsert.phtml）内のContentPaneコンポーネントに埋め込まれて表示されます。初期表示時に自動的にロードされ、プレビューボタン押下時にAjaxで更新されます。

**主要な操作・処理内容**：
1. 指定されたアセットキー、幅、高さ、リサイズタイプに基づく画像サムネイルの生成
2. PhpThumbライブラリを使用したリサイズ処理の実行
3. リサイズ結果のプレビュー画像表示

**画面遷移**：
- 遷移元：画像挿入画面（imageinsert.phtml）のContentPane
- 遷移先：なし（埋め込み表示のみ）

**権限による表示制御**：fassets権限を持つユーザーのみがこの画面にアクセスできます。権限がない場合は権限エラー画面へ転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | アセット一覧表示 | 主機能 | 画像のプレビューを表示 |

## 画面種別

プレビュー（部分画面/Ajax読み込み）

## URL/ルーティング

```
/admin/assets/imagepreview/key/{asset_key}/width/{width}/height/{height}/type/{resize_type}/
```

| パラメータ | 説明 | 必須 | 例 |
|-----------|------|------|-----|
| key | アセットキー（MD5ハッシュ） | Yes | abc123def456... |
| width | プレビュー幅（ピクセル） | Yes | 640 |
| height | プレビュー高さ（ピクセル） | Yes | 480 |
| type | リサイズタイプ | Yes | resize/adaptive/crop |

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| アセットキー | key | string | Yes | 対象画像のMD5キー |
| 幅 | width | integer | Yes | リサイズ後の幅（px） |
| 高さ | height | integer | Yes | リサイズ後の高さ（px） |
| リサイズタイプ | type | string | Yes | resize/adaptive/crop |

### リサイズタイプの説明

| タイプ | 説明 |
|--------|------|
| resize | アスペクト比を維持して指定サイズ内に収める（Fit to Box） |
| adaptive | 指定サイズにアダプティブクロップ（Adaptive Crop） |
| crop | 中央からクロップ（Crop from Center） |

## 表示項目

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| プレビュー画像 | - | thumbpreviewAction | IMG要素 | リサイズされた画像 |

## イベント仕様

### 1-画面読み込み（初期表示）

**トリガー**：画像挿入画面のContentPaneによる自動読み込み

**処理内容**：
1. URLパラメータからkey, width, height, typeを取得
2. 対応するIMG要素を生成
3. IMG要素のsrcにthumbpreviewアクションのURLを設定

**画面遷移**：なし（埋め込み表示）

### 2-プレビュー更新（Ajax更新）

**トリガー**：画像挿入画面のPreviewボタン押下によるimagePreview JavaScript関数呼び出し

**処理内容**：
1. ContentPaneのhref属性を新しいパラメータで更新
2. ContentPaneをリロードして新しいプレビューを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プレビュー表示 | assets | SELECT | アセット情報の取得（thumbpreviewAction経由） |

### テーブル別更新項目詳細

#### assets（参照のみ - thumbpreviewAction経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | asset_key | リクエストパラメータのkeyと一致 | 検索キー |
| SELECT | asset_file | - | ファイルパス取得用 |
| SELECT | asset_mime | - | MIMEタイプ確認用 |
| SELECT | asset_extension | - | 拡張子取得用 |
| SELECT | asset_id | - | サムネイルファイル名生成用 |

## メッセージ仕様

本画面は画像を表示するだけの画面のため、メッセージは表示されません。

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| fassets権限がない | 権限エラー画面へ転送 | privileges.phtml |
| アセットが存在しない | notfound画像を表示 | デフォルト画像 |
| 画像以外のアセット | invalid画像を表示 | デフォルト画像 |
| ファイルが存在しない | notfound画像を表示 | デフォルト画像 |

## 備考

- 本画面は非常にシンプルで、IMG要素のみを出力します
- 実際のリサイズ処理はthumbpreviewActionで行われ、PhpThumbライブラリを使用します
- レイアウトは無効化されており、純粋なHTML出力のみです
- サムネイル生成済みの場合はキャッシュから読み込まれます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

画像プレビューはassetsテーブルの画像ファイルを参照します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | thumbpreviewAction（1104-1177行目）でアセット情報の取得方法を確認 |

**読解のコツ**: imagepreviewActionは単純なビュー表示のみで、実際の画像処理はthumbpreviewActionで行われます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | imagepreviewAction（1083-1099行目）の処理フローを確認 |

**主要処理フロー**:
1. **1085行目**: ACLによる権限チェック（fassets権限）
2. **1087行目**: レイアウト無効化
3. **1089-1092行目**: key, width, height, typeパラメータの取得
4. **各パラメータをビュー変数として設定**

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | imagepreview.phtml | `application/modules/admin/views/scripts/assets/imagepreview.phtml` | 9行目のIMG要素生成を確認 |

**主要処理フロー**:
- **9行目**: /admin/assets/thumbpreview/...のURLでIMG要素を生成

#### Step 4: サムネイルプレビュー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | thumbpreviewAction（1104-1177行目）のリサイズロジックを確認 |

**主要処理フロー**:
- **1113-1116行目**: パラメータ取得
- **1124-1136行目**: assetsテーブルからアセット情報取得
- **1142-1145行目**: 画像タイプの確認
- **1153-1161行目**: PhpThumbによるリサイズ処理（adaptive/resize/crop）
- **1163行目**: $thumb->show()で画像出力

### プログラム呼び出し階層図

```
[画像挿入画面のContentPane]
    │
    ├─ /admin/assets/imagepreview/key/.../width/.../height/.../type/.../
    │      │
    │      └─ AssetsController::imagepreviewAction()
    │             ├─ ACL権限チェック（fassets）
    │             └─ ビュー変数セット（key, width, height, type）
    │
    └─ imagepreview.phtml
           │
           └─ <img src="/admin/assets/thumbpreview/...">
                  │
                  └─ AssetsController::thumbpreviewAction()
                         ├─ assetsテーブル参照
                         ├─ 画像ファイル読み込み
                         ├─ PhpThumbFactory::create()
                         ├─ リサイズ処理（adaptive/resize/crop）
                         └─ 画像バイナリ出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

key ─────────────▶ imagepreviewAction ────▶ IMG要素HTML
width ───────────▶      │
height ──────────▶      │
type ────────────▶      ▼
                   imagepreview.phtml
                        │
                        ▼
                   thumbpreviewAction ────▶ 画像バイナリ
                        │
                        ▼
                   PhpThumbFactory
                   (リサイズ処理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | imagepreviewAction, thumbpreviewAction |
| imagepreview.phtml | `application/modules/admin/views/scripts/assets/imagepreview.phtml` | ビュー | プレビュー画像表示テンプレート |
| imageinsert.phtml | `application/modules/admin/views/scripts/assets/imageinsert.phtml` | ビュー | 親画面（画像挿入ダイアログ） |
| PhpThumbFactory | `library/PhpThumb/` | ライブラリ | 画像リサイズ処理 |
