# 画面設計書 83-画像挿入画面

## 概要

本ドキュメントは、Legacy CMS管理画面の画像挿入画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、WYSIWYGエディタ（記事編集、ページ編集等）に画像を挿入するためのダイアログ画面です。アセット管理画面で選択した画像のリサイズオプションを設定し、プレビューを確認した上でエディタに挿入できます。

**業務上の目的・背景**：コンテンツ管理において、記事やページに画像を挿入する作業は頻繁に発生します。画像は元のサイズのままでは大きすぎたり、レイアウトに合わなかったりすることがあります。本画面は、画像のリサイズ方法（Fit to Box、Adaptive Crop、Crop from Center）とサイズを指定し、プレビューで確認してからエディタに挿入できる機能を提供します。これにより、コンテンツ作成者は試行錯誤することなく、適切なサイズの画像を効率的に挿入できます。

**画面へのアクセス方法**：アセット管理画面で画像アセットを選択し、「Insert Image」オプションを選択することでAjaxダイアログとして表示されます。または、WYSIWYGエディタの画像挿入ボタンからアセット選択後に表示されます。

**主要な操作・処理内容**：
1. リサイズタイプの選択（Fit to Box / Adaptive Crop / Crop from Center）
2. 幅と高さの数値入力（ピクセル単位）
3. プレビューボタンによるリサイズ結果の確認
4. 挿入ボタンによるエディタへの画像挿入
5. キャンセルボタンによるダイアログの閉じる処理

**画面遷移**：
- 遷移元：アセット管理画面、WYSIWYGエディタの画像選択機能
- 遷移先：なし（エディタに画像を挿入してダイアログを閉じる）

**権限による表示制御**：fassets権限を持つユーザーのみがこの画面にアクセスできます。権限がない場合は権限エラー画面へ転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | アセット選択 | 主機能 | エディタへの画像挿入ダイアログ |
| 64 | Ajaxダイアログ | 補助機能 | 画像選択ダイアログの表示 |

## 画面種別

ダイアログ（Ajax読み込み）

## URL/ルーティング

```
/admin/assets/imageinsert/key/{asset_key}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| key | アセットキー（MD5ハッシュ） | Yes |

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| アセットキー | key | string | Yes | 対象画像のMD5キー |

### フォーム入力項目

| 項目名 | フィールド名 | 型 | 必須 | 初期値 | 説明 |
|--------|-------------|-----|------|--------|------|
| リサイズタイプ | type | select | Yes | resize | Fit to Box/Adaptive Crop/Crop from Center |
| 幅 | width | integer | Yes | 画像の元幅 | リサイズ後の幅（px） |
| 高さ | height | integer | Yes | 画像の元高さ | リサイズ後の高さ（px） |

### リサイズタイプ選択肢

| 値 | 表示名 | 説明 |
|-----|--------|------|
| resize | Fit to Box | アスペクト比を維持してボックス内に収める |
| adaptive | Adaptive Crop | 指定サイズにアダプティブクロップ |
| crop | Crop from Center | 中央からクロップ |

## 表示項目

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| プレビュー画像 | - | imagepreviewAction | 画像 | リサイズ結果のプレビュー |

## イベント仕様

### 1-Preview（プレビュー）ボタン押下

**トリガー**：「Preview」ボタンをクリック

**処理内容**：
1. imagePreview JavaScript関数を呼び出し
2. type, width, heightの現在値を取得
3. imagePreviewコンテナのContentPaneをリロード
4. 新しいパラメータでプレビュー画像を更新

**画面遷移**：なし（プレビューエリアのみ更新）

### 2-Insert（挿入）ボタン押下

**トリガー**：「Insert」ボタンをクリック

**処理内容**：
1. imageInsert JavaScript関数を呼び出し
2. 現在のtype, width, heightパラメータで画像URLを生成
3. WYSIWYGエディタに画像タグを挿入
4. ダイアログを閉じる

**画面遷移**：ダイアログが閉じ、エディタに画像が挿入された状態で元の画面に戻る

### 3-Cancel（キャンセル）ボタン押下

**トリガー**：「Cancel」ボタンをクリック

**処理内容**：
1. dijit.byId('ajaxDialog').hide()を実行
2. ダイアログを非表示にする

**画面遷移**：ダイアログが閉じ、画像挿入なしで元の画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets | SELECT | アセット情報・画像サイズの取得 |

### テーブル別更新項目詳細

#### assets（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | asset_key | リクエストパラメータのkeyと一致 | 検索キー |
| SELECT | asset_file | - | ファイルパス取得用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| バリデーション | Invalid width | 幅の入力値が不正な場合 |
| バリデーション | Invalid height | 高さの入力値が不正な場合 |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| fassets権限がない | 権限エラー画面へ転送 | privileges.phtml |
| アセットが存在しない | エラー表示 | エラーダイアログ |
| ファイルが存在しない | エラー表示 | エラーダイアログ |

## 備考

- 本画面はAjaxダイアログとして表示されるため、レイアウトは無効化されています
- Dojo Toolkitのdijit.form.Formウィジェットを使用しています
- 初期表示時に画像の元サイズ（width, height）がgetimagesize関数で取得されます
- プレビューエリアは800x450ピクセルのスクロール可能なContentPaneです
- 画像の実際のリサイズはthumbpreviewActionで行われ、PHPThumbライブラリを使用します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

画像挿入画面では、アセット情報と画像サイズ情報を扱います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | imageinsertAction（1043-1078行目）のデータ取得処理を確認 |

**読解のコツ**: getimagesize()関数で元の画像サイズを取得し、ビュー変数$sizeにセットしています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | imageinsertAction（1043-1078行目）の処理フローを確認 |

**主要処理フロー**:
1. **1045行目**: ACLによる権限チェック（fassets権限）
2. **1047行目**: レイアウト無効化
3. **1049行目**: keyパラメータ（アセットキー）の取得
4. **1055-1061行目**: assetsテーブルからアセット情報を取得
5. **1065-1068行目**: ファイルパスを構築
6. **1069行目**: getimagesize()で画像サイズを取得
7. **1071行目**: ビュー変数$sizeをセット（width, height）

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | imageinsert.phtml | `application/modules/admin/views/scripts/assets/imageinsert.phtml` | フォーム構造と各ボタンの処理を確認 |

**主要処理フロー**:
- **9-22行目**: リサイズタイプのセレクトボックス（resize/adaptive/crop）
- **24-36行目**: Width入力フィールド（初期値：$this->size['width']）
- **38-50行目**: Height入力フィールド（初期値：$this->size['height']）
- **52-58行目**: Previewボタン（imagePreview関数呼び出し）
- **60行目**: ContentPane（プレビュー表示エリア、800x450px）
- **63-68行目**: Insertボタン（imageInsert関数呼び出し）
- **69-74行目**: Cancelボタン（ダイアログを閉じる）

### プログラム呼び出し階層図

```
[Ajaxリクエスト: /admin/assets/imageinsert/key/{key}/]
    │
    ├─ AssetsController::imageinsertAction()
    │      ├─ ACL権限チェック（fassets）
    │      ├─ assetsテーブル参照（asset_key検索）
    │      ├─ ファイルパス構築
    │      ├─ getimagesize()で画像サイズ取得
    │      └─ View変数セット（$key, $size）
    │
    └─ imageinsert.phtml
           ├─ リサイズタイプ選択フォーム
           ├─ Width/Height入力フィールド
           ├─ Previewボタン → imagePreview(key)
           │      └─ ContentPane更新 → imagepreviewAction
           ├─ ContentPane（プレビュー表示）
           │      └─ /admin/assets/imagepreview/...
           ├─ Insertボタン → imageInsert(key)
           │      └─ エディタに画像タグ挿入
           └─ Cancelボタン → dijit.byId('ajaxDialog').hide()
```

### データフロー図

```
[入力]               [処理]                    [出力]

asset_key ────────▶ imageinsertAction ────▶ フォームHTML
(URLパラメータ)           │
                          ▼
                   assetsテーブル参照
                          │
                          ▼
                   getimagesize()
                   (元画像サイズ取得)
                          │
                          ▼
                   imageinsert.phtml
                   (フォーム表示)
                          │
        ┌─────────────────┴─────────────────┐
        ▼                                   ▼
   Previewボタン                       Insertボタン
        │                                   │
        ▼                                   ▼
   imagepreviewAction               imageInsert JS関数
   (プレビュー更新)                  (エディタに挿入)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | imageinsertActionの処理 |
| imageinsert.phtml | `application/modules/admin/views/scripts/assets/imageinsert.phtml` | ビュー | 画像挿入フォームテンプレート |
| imagepreview.phtml | `application/modules/admin/views/scripts/assets/imagepreview.phtml` | ビュー | プレビュー画像表示 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | imagePreview, imageInsert関数 |
| PhpThumbFactory | `library/PhpThumb/` | ライブラリ | 画像リサイズ処理 |
