# 画面設計書 84-リンク挿入画面

## 概要

本ドキュメントは、Legacy CMS管理画面のリンク挿入画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、WYSIWYGエディタ（記事編集、ページ編集等）にアセットへのリンクを挿入するためのダイアログ画面です。アセット管理画面で選択したファイルのリンクタイプ（ダウンロード/ブラウザで開く）を選択し、エディタにリンクを挿入できます。

**業務上の目的・背景**：コンテンツ管理において、PDF文書やその他のファイルへのリンクを記事やページに挿入する作業が発生します。本画面は、リンクの種類（ダウンロード形式またはブラウザで開く形式）を選択できる機能を提供します。ダウンロード形式はユーザーにファイルを保存させたい場合に、ブラウザで開く形式はPDFなどを直接表示させたい場合に使用します。これにより、コンテンツの目的に応じた適切なリンク形式を選択できます。

**画面へのアクセス方法**：アセット管理画面でファイルアセットを選択し、「Insert Link」オプションを選択することでAjaxダイアログとして表示されます。または、WYSIWYGエディタのリンク挿入ボタンからアセット選択後に表示されます。

**主要な操作・処理内容**：
1. リンクタイプの選択（Download Asset / Open Asset In Browser）
2. 挿入ボタンによるエディタへのリンク挿入
3. キャンセルボタンによるダイアログの閉じる処理

**画面遷移**：
- 遷移元：アセット管理画面、WYSIWYGエディタのリンク選択機能
- 遷移先：なし（エディタにリンクを挿入してダイアログを閉じる）

**権限による表示制御**：fassets権限を持つユーザーのみがこの画面にアクセスできます。権限がない場合は権限エラー画面へ転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | アセット選択 | 主機能 | エディタへのリンク挿入ダイアログ |
| 64 | Ajaxダイアログ | 補助機能 | リンク選択ダイアログの表示 |

## 画面種別

ダイアログ（Ajax読み込み）

## URL/ルーティング

```
/admin/assets/linkinsert/key/{asset_key}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| key | アセットキー（MD5ハッシュ） | Yes |

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| アセットキー | key | string | Yes | 対象ファイルのMD5キー |

### フォーム入力項目

| 項目名 | フィールド名 | 型 | 必須 | 初期値 | 説明 |
|--------|-------------|-----|------|--------|------|
| リンクタイプ | method | radio | Yes | download | Download Asset/Open Asset In Browser |

### リンクタイプ選択肢

| 値 | 表示名 | 説明 |
|-----|--------|------|
| download | Download Asset | ダウンロードダイアログを表示してファイルを保存 |
| open | Open Asset In Browser | ブラウザ内でファイルを表示（PDF等） |

## 表示項目

本画面はフォーム入力のみで、データ表示項目はありません。

## イベント仕様

### 1-Insert（挿入）ボタン押下

**トリガー**：「Insert」ボタンをクリック

**処理内容**：
1. linkInsert JavaScript関数を呼び出し
2. 選択されたmethod（download/open）を取得
3. 対応するアセットURLを生成
   - download: `/admin/assets/download/key/{key}/`
   - open: `/admin/assets/open/key/{key}/`
4. WYSIWYGエディタにリンクタグを挿入
5. ダイアログを閉じる

**画面遷移**：ダイアログが閉じ、エディタにリンクが挿入された状態で元の画面に戻る

### 2-Cancel（キャンセル）ボタン押下

**トリガー**：「Cancel」ボタンをクリック

**処理内容**：
1. dijit.byId('ajaxDialog').hide()を実行
2. ダイアログを非表示にする

**画面遷移**：ダイアログが閉じ、リンク挿入なしで元の画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | なし | パラメータのみ使用（DB参照なし） |

本画面はフォーム表示のみのため、画面表示時のデータベースアクセスはありません。

### 関連するデータベース処理（リンク利用時）

挿入されたリンクがユーザーにクリックされた際の処理：

| アクション | 対象テーブル | 操作種別 | 概要 |
|-----------|-------------|---------|------|
| downloadAction | assets | SELECT | asset_keyでアセット情報を取得 |
| openAction | assets | SELECT | asset_keyでアセット情報を取得 |

## メッセージ仕様

本画面はシンプルなフォームのため、メッセージは表示されません。

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| fassets権限がない | 権限エラー画面へ転送 | privileges.phtml |

## 備考

- 本画面はAjaxダイアログとして表示されるため、レイアウトは無効化されています
- Dojo Toolkitのdijit.form.FormおよびRadioButtonウィジェットを使用しています
- 画像挿入画面（No.83）と異なり、プレビュー機能はありません
- 挿入されるリンクのURLは、選択したmethod（download/open）によって異なるアクションを呼び出します
- downloadActionはContent-Dispositionヘッダーを「attachment」に設定
- openActionはContent-Dispositionヘッダーを「inline」に設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はシンプルで、keyパラメータのみをビューに渡します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | linkinsertAction（1183-1196行目）の構造を確認 |

**読解のコツ**: この画面は非常にシンプルで、keyパラメータをビュー変数にセットするだけです。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | linkinsertAction（1183-1196行目）の処理フローを確認 |

**主要処理フロー**:
1. **1185行目**: ACLによる権限チェック（fassets権限）
2. **1187行目**: レイアウト無効化
3. **1189行目**: keyパラメータ（アセットキー）の取得
4. **keyをビュー変数にセット**

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | linkinsert.phtml | `application/modules/admin/views/scripts/assets/linkinsert.phtml` | ラジオボタンと各ボタンの処理を確認 |

**主要処理フロー**:
- **9-22行目**: Link Typeラジオボタン
  - **12-15行目**: Download Asset（初期選択）
  - **17-21行目**: Open Asset In Browser
- **25-30行目**: Insertボタン（linkInsert関数呼び出し）
- **31-36行目**: Cancelボタン（ダイアログを閉じる）

#### Step 4: 関連するダウンロード/オープン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | downloadAction（140-195行目）の処理を確認 |
| 4-2 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | openAction（200-255行目）の処理を確認 |

**downloadActionの主要処理**:
- **174行目**: Content-Disposition: attachment（ダウンロードとして扱う）
- **177行目**: レスポンスボディにファイルデータをセット

**openActionの主要処理**:
- **234行目**: Content-Disposition: inline（ブラウザ内で表示）
- **237行目**: レスポンスボディにファイルデータをセット

### プログラム呼び出し階層図

```
[Ajaxリクエスト: /admin/assets/linkinsert/key/{key}/]
    │
    ├─ AssetsController::linkinsertAction()
    │      ├─ ACL権限チェック（fassets）
    │      └─ View変数セット（$key）
    │
    └─ linkinsert.phtml
           ├─ Link Typeラジオボタン
           │      ├─ download（初期選択）
           │      └─ open
           ├─ Insertボタン → linkInsert(key)
           │      └─ エディタにリンクタグ挿入
           └─ Cancelボタン → dijit.byId('ajaxDialog').hide()

[リンクがクリックされた場合]
    │
    ├─ /admin/assets/download/key/{key}/ → downloadAction()
    │      ├─ assetsテーブル参照
    │      ├─ ファイル読み込み
    │      └─ attachment形式でレスポンス
    │
    └─ /admin/assets/open/key/{key}/ → openAction()
           ├─ assetsテーブル参照
           ├─ ファイル読み込み
           └─ inline形式でレスポンス
```

### データフロー図

```
[入力]               [処理]                    [出力]

asset_key ────────▶ linkinsertAction ─────▶ フォームHTML
(URLパラメータ)           │
                          ▼
                   linkinsert.phtml
                   (フォーム表示)
                          │
                          ▼
                   linkInsert JS関数
                          │
        ┌─────────────────┴─────────────────┐
        ▼                                   ▼
   method=download                     method=open
        │                                   │
        ▼                                   ▼
   /admin/assets/download/...        /admin/assets/open/...
   (ダウンロードリンク)              (ブラウザ表示リンク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | linkinsertAction, downloadAction, openAction |
| linkinsert.phtml | `application/modules/admin/views/scripts/assets/linkinsert.phtml` | ビュー | リンク挿入フォームテンプレート |
| common.js | `public/_scripts/admin/common.js` | JavaScript | linkInsert関数 |
