# 画面設計書 85-コメント管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面のコメント管理画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、CMSに投稿されたすべてのコメントを一覧表示し、承認・非承認・削除などの管理操作を行うための画面です。記事やページに対するユーザーコメントを効率的に管理できます。

**業務上の目的・背景**：CMSでユーザーからのコメントを受け付ける場合、スパムや不適切なコメントを管理する必要があります。本画面は、投稿されたコメントを一覧表示し、著者やコンテンツ種別でフィルタリングしながら、承認・非承認・削除の操作を効率的に行えます。これにより、管理者はコメントの品質を維持し、コミュニティの健全性を保つことができます。

**画面へのアクセス方法**：管理画面のメニューから「Comments」を選択することでアクセスできます。または、記事詳細画面やページ詳細画面のコメントタブから遷移することもできます。

**主要な操作・処理内容**：
1. コメント一覧の表示（ページネーション付き、15件/ページ）
2. 著者フィルタによるコメントの絞り込み
3. コンテンツ種別・ID（type/slave）によるフィルタリング
4. コメントの承認（Approve）操作
5. コメントの非承認（Disapprove）操作
6. コメントの削除（Delete）操作

**画面遷移**：
- 遷移元：管理ダッシュボード、記事詳細画面、ページ詳細画面
- 遷移先：ユーザー編集画面（著者リンク）

**権限による表示制御**：
- gcomments権限：画面へのアクセス権限
- gcommentsstatus権限：承認・非承認操作の表示
- gcommentdelete権限：削除操作の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | コメント一覧表示 | 主機能 | コメント一覧を表示 |
| 62 | ページネーション | 補助機能 | コメント一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |
| 46 | コメント削除 | 遷移先機能 | コメント削除ダイアログへの遷移 |

## 画面種別

一覧

## URL/ルーティング

```
/admin/comments/manage/
/admin/comments/manage/author/{author_id}/
/admin/comments/manage/type/{type}/slave/{slave_id}/
/admin/comments/manage/author/{author_id}/type/{type}/slave/{slave_id}/
```

| パラメータ | 説明 | 必須 | 例 |
|-----------|------|------|-----|
| author | 著者ユーザーID | No | 1 |
| type | コンテンツ種別 | No | A（記事）/ P（ページ） |
| slave | コンテンツID | No | 123 |
| page | ページ番号 | No | 1 |

## 入出力項目

### フィルタ条件（URL パラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 著者ID | author | integer | No | コメント投稿者のユーザーID |
| コンテンツ種別 | type | string | No | A=記事、P=ページ等 |
| コンテンツID | slave | integer | No | 記事ID、ページID等 |
| ページ番号 | page | integer | No | ページネーション用 |

## 表示項目

### フィルタ表示エリア

| 項目名 | 表示条件 | 操作 | 説明 |
|--------|---------|------|------|
| Author: {著者名} | author != NULL | クリックで解除 | 著者フィルタの表示 |
| {種別}: {タイトル} | type != NULL && slave != NULL | クリックで解除 | コンテンツフィルタの表示 |
| No active filter | フィルタなし | - | フィルタ未適用の表示 |

### コメント一覧

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| コメント投稿者 | ユーザーアイコン + 名前 | user_alias | リンク | フィルタリンク |
| 投稿日時 | 日付アイコン + 日付 | comment_date | 日付 | d/m/Y形式 |
| コンテンツ種別 | {種別}: {タイトル} | comment_type, slaveTitle | テキスト | リンク付き |
| コメント本文 | - | comment_content | テキスト | 全文表示 |

### 操作ボタン（マウスオーバー時表示）

| 操作 | 表示条件 | 説明 |
|------|---------|------|
| Approve | gcommentsstatus権限 && comment_approved='N' | 承認操作 |
| Disapprove | gcommentsstatus権限 && comment_approved='Y' | 非承認操作 |
| Delete | gcommentdelete権限 | 削除操作 |

## イベント仕様

### 1-著者フィルタ適用

**トリガー**：著者名リンクをクリック

**処理内容**：
1. URLにauthor={user_id}パラメータを付加
2. コメント一覧をフィルタリングして再表示

**画面遷移**：同一画面（フィルタ適用状態）

### 2-著者フィルタ解除

**トリガー**：フィルタエリアの著者タグをクリック

**処理内容**：
1. URLからauthorパラメータを除去
2. コメント一覧を再表示

**画面遷移**：同一画面（フィルタ解除状態）

### 3-コンテンツフィルタ適用

**トリガー**：コンテンツタイトルリンクをクリック

**処理内容**：
1. URLにtype={type}&slave={slave_id}パラメータを付加
2. コメント一覧をフィルタリングして再表示

**画面遷移**：同一画面（フィルタ適用状態）

### 4-Approve（承認）操作

**トリガー**：「Approve」リンクをクリック

**処理内容**：
1. approveComment JavaScript関数を呼び出し
2. /admin/comments/approve/id/{id}/status/Y/ajax/0/にAjaxリクエスト
3. commentsテーブルのcomment_approved列を'Y'に更新
4. 完了ダイアログを表示

**画面遷移**：ダイアログ表示後、ページリロード

### 5-Disapprove（非承認）操作

**トリガー**：「Disapprove」リンクをクリック

**処理内容**：
1. approveComment JavaScript関数を呼び出し
2. /admin/comments/approve/id/{id}/status/N/ajax/0/にAjaxリクエスト
3. commentsテーブルのcomment_approved列を'N'に更新
4. 完了ダイアログを表示

**画面遷移**：ダイアログ表示後、ページリロード

### 6-Delete（削除）操作

**トリガー**：「Delete」リンクをクリック

**処理内容**：
1. deleteComment JavaScript関数を呼び出し
2. /admin/comments/delete/id/{id}/ajax/0/にAjaxリクエスト
3. commentsテーブルから該当レコードを削除
4. 完了ダイアログを表示

**画面遷移**：ダイアログ表示後、ページリロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | comments, users | SELECT | コメント一覧の取得 |
| Approve | comments | UPDATE | comment_approved='Y'に更新 |
| Disapprove | comments | UPDATE | comment_approved='N'に更新 |
| Delete | comments | DELETE | コメントレコードの削除 |

### テーブル別更新項目詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | comment_id | - | 主キー |
| SELECT | comment_user | - | usersテーブルとJOIN |
| SELECT | comment_type | - | コンテンツ種別 |
| SELECT | comment_slave | - | コンテンツID |
| SELECT | comment_content | - | コメント本文 |
| SELECT | comment_date | - | 投稿日時 |
| SELECT | comment_approved | - | 承認状態 |
| UPDATE | comment_approved | 'Y' または 'N' | Approve/Disapprove時 |
| DELETE | - | comment_id = {id} | Delete時 |

#### users（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_alias | - | 表示名 |
| SELECT | user_role | - | ロール情報 |
| SELECT | user_id | - | フィルタ用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No Comments! | コメントが0件の場合 |
| 成功 | Comment approved | Approve操作成功時（ダイアログ） |
| 成功 | Comment disapproved | Disapprove操作成功時（ダイアログ） |
| 成功 | Comment deleted | Delete操作成功時（ダイアログ） |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| gcomments権限がない | 権限エラー画面へ転送 | privileges.phtml |

## 備考

- 未承認コメントはnotapprovedクラスが付与され、視覚的に区別されます
- コメント操作ボタンはマウスオーバー時のみ表示されます（toggleDisp関数）
- ページネーションは1ページあたり15件、ページレンジは5件です
- cslaveDetailsビューヘルパーでコンテンツ詳細（種別、タイトル）を取得します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメント管理ではcommentsテーブルとusersテーブルをJOINして使用します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Comments.php | `application/models/Comments.php` | コメントモデルの構造とfetchComments関数を確認 |

**読解のコツ**: コメントはcomment_type（A=記事、P=ページ等）とcomment_slave（コンテンツID）で紐づけされています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | manageAction（53-124行目）の処理フローを確認 |

**主要処理フロー**:
1. **55行目**: ACLによる権限チェック（gcomments権限）
2. **57行目**: レイアウト設定（admin）
3. **59-63行目**: フィルタパラメータ（type, slave, author）の取得
4. **65-70行目**: ページパラメータの取得（デフォルト: 1）
5. **75-107行目**: フィルタ条件に応じたSELECTクエリ構築
6. **109-113行目**: Zend_Paginatorによるページネーション設定

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/comments/manage.phtml` | フィルタ表示、コメント一覧、操作ボタンの構造を確認 |

**主要処理フロー**:
- **31-38行目**: フィルタ表示エリア（tagItmクラス）
- **40-72行目**: コメント一覧のループ表示
- **42-55行目**: 権限に応じた操作ボタンの表示制御
- **78-82行目**: ページネーションコントロール

#### Step 4: 承認・削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | approveAction（210-287行目）の処理を確認 |
| 4-2 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | deleteAction（165-205行目）の処理を確認 |

### プログラム呼び出し階層図

```
[リクエスト: /admin/comments/manage/]
    │
    ├─ CommentsController::manageAction()
    │      ├─ ACL権限チェック（gcomments）
    │      ├─ フィルタパラメータ取得
    │      ├─ SQLクエリ構築（comments JOIN users）
    │      ├─ Zend_Paginatorでページネーション
    │      └─ View変数セット（$commentArray）
    │
    └─ manage.phtml
           ├─ フィルタ表示エリア
           ├─ コメント一覧ループ
           │      ├─ 権限チェック（gcommentsstatus, gcommentdelete）
           │      ├─ 操作ボタン表示
           │      └─ コメント内容表示
           └─ ページネーションコントロール

[Approve/Disapprove操作]
    │
    └─ approveComment(id, status, ajax)
           │
           └─ /admin/comments/approve/id/.../status/.../
                  └─ CommentsController::approveAction()
                         └─ UPDATE comments SET comment_approved = ...

[Delete操作]
    │
    └─ deleteComment(id, ajax)
           │
           └─ /admin/comments/delete/id/.../
                  └─ CommentsController::deleteAction()
                         └─ DELETE FROM comments WHERE ...
```

### データフロー図

```
[入力]               [処理]                    [出力]

フィルタパラメータ ─▶ manageAction ─────────▶ コメント一覧
(author/type/slave)       │
                          ▼
                   comments + users
                   テーブルJOIN
                          │
                          ▼
                   Zend_Paginator
                   (15件/ページ)
                          │
                          ▼
                   manage.phtml ─────────────▶ HTML一覧
                          │
        ┌─────────────────┼─────────────────┐
        ▼                 ▼                 ▼
   Approve           Disapprove          Delete
        │                 │                 │
        ▼                 ▼                 ▼
   UPDATE             UPDATE            DELETE
   approved='Y'       approved='N'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | manage/approve/deleteAction |
| manage.phtml | `application/modules/admin/views/scripts/comments/manage.phtml` | ビュー | コメント一覧テンプレート |
| Comments.php | `application/models/Comments.php` | モデル | コメントデータ操作 |
| comments.js | `public/_scripts/admin/comments.js` | JavaScript | approveComment, deleteComment関数 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | toggleDisp関数 |
