# 画面設計書 86-コメント表示画面

## 概要

本ドキュメントは、Legacy CMS管理画面のコメント表示画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、特定のコンテンツ（記事、ページ等）に紐づくコメントを一覧表示する部分画面です。記事詳細画面やページ詳細画面のタブ内に埋め込まれて表示され、コメントの承認・非承認・削除操作を提供します。

**業務上の目的・背景**：記事やページの編集・管理画面において、そのコンテンツに対するコメントを確認・管理する必要があります。本画面は、コンテンツ詳細画面のコメントタブ内に表示され、関連するコメントのみをフィルタリングして表示します。これにより、管理者は特定のコンテンツに関するコメントを効率的に管理できます。

**画面へのアクセス方法**：記事詳細画面、ページ詳細画面、イベント詳細画面等のコメントタブから、Ajax経由で読み込まれます。ContentPaneの自動読み込みによって表示されます。

**主要な操作・処理内容**：
1. 特定コンテンツに紐づくコメントの一覧表示
2. コメントの承認（Approve）操作
3. コメントの非承認（Disapprove）操作
4. コメントの削除（Delete）操作
5. ユーザー編集画面へのリンク

**画面遷移**：
- 遷移元：記事詳細画面、ページ詳細画面、イベント詳細画面（タブ内読み込み）
- 遷移先：ユーザー編集画面（著者リンク）

**権限による表示制御**：
- gcomments権限：画面へのアクセス権限
- gcommentsstatus権限：承認・非承認操作の表示
- gcommentdelete権限：削除操作の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | コメント表示 | 主機能 | コメントの詳細を表示 |
| 47 | コメント承認/非承認 | 補助機能 | コメントの承認ステータス切り替え |

## 画面種別

一覧（部分画面/Ajax読み込み）

## URL/ルーティング

```
/admin/comments/show/type/{type}/slave/{slave_id}/
```

| パラメータ | 説明 | 必須 | 例 |
|-----------|------|------|-----|
| type | コンテンツ種別 | Yes | A（記事）/ P（ページ）/ E（イベント） |
| slave | コンテンツID | Yes | 123 |

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| コンテンツ種別 | type | string | Yes | A=記事、P=ページ、E=イベント等 |
| コンテンツID | slave | integer | Yes | 記事ID、ページID等 |

## 表示項目

### コメント一覧

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| コメント投稿者 | ユーザーアイコン + 名前 | user_alias | リンク | ユーザー編集画面へ |
| 投稿日時 | 日付アイコン + 日付 | comment_date | 日付 | d/m/Y形式 |
| コメント本文 | - | comment_content | テキスト | 全文表示 |

### 操作ボタン（マウスオーバー時表示）

| 操作 | 表示条件 | 説明 |
|------|---------|------|
| Approve | gcommentsstatus権限 && comment_approved='N' | 承認操作 |
| Disapprove | gcommentsstatus権限 && comment_approved='Y' | 非承認操作 |
| Delete | gcommentdelete権限 | 削除操作 |

## イベント仕様

### 1-著者名リンククリック

**トリガー**：著者名リンクをクリック

**処理内容**：
1. /admin/users/edit/id/{user_id}/に遷移

**画面遷移**：ユーザー編集画面

### 2-Approve（承認）操作

**トリガー**：「Approve」リンクをクリック

**処理内容**：
1. approveComment JavaScript関数を呼び出し（ajax=1）
2. /admin/comments/approve/id/{id}/status/Y/ajax/1/にAjaxリクエスト
3. commentsテーブルのcomment_approved列を'Y'に更新
4. 完了ダイアログを表示（Closeボタンでダイアログのみ閉じる）

**画面遷移**：ダイアログ表示（ページリロードなし）

### 3-Disapprove（非承認）操作

**トリガー**：「Disapprove」リンクをクリック

**処理内容**：
1. approveComment JavaScript関数を呼び出し（ajax=1）
2. /admin/comments/approve/id/{id}/status/N/ajax/1/にAjaxリクエスト
3. commentsテーブルのcomment_approved列を'N'に更新
4. 完了ダイアログを表示（Closeボタンでダイアログのみ閉じる）

**画面遷移**：ダイアログ表示（ページリロードなし）

### 4-Delete（削除）操作

**トリガー**：「Delete」リンクをクリック

**処理内容**：
1. deleteComment JavaScript関数を呼び出し（ajax=1）
2. /admin/comments/delete/id/{id}/ajax/1/にAjaxリクエスト
3. commentsテーブルから該当レコードを削除
4. 完了ダイアログを表示（Closeボタンでダイアログのみ閉じる）

**画面遷移**：ダイアログ表示（ページリロードなし）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | comments, users | SELECT | コメント一覧の取得 |
| Approve | comments | UPDATE | comment_approved='Y'に更新 |
| Disapprove | comments | UPDATE | comment_approved='N'に更新 |
| Delete | comments | DELETE | コメントレコードの削除 |

### テーブル別更新項目詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | comment_id | - | 主キー |
| SELECT | comment_user | - | usersテーブルとJOIN |
| SELECT | comment_type | = type パラメータ | フィルタ条件 |
| SELECT | comment_slave | = slave パラメータ | フィルタ条件 |
| SELECT | comment_content | - | コメント本文 |
| SELECT | comment_date | - | 投稿日時 |
| SELECT | comment_approved | - | 承認状態 |
| UPDATE | comment_approved | 'Y' または 'N' | Approve/Disapprove時 |
| DELETE | - | comment_id = {id} | Delete時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No Comments! | コメントが0件の場合 |
| 成功 | Comment approved | Approve操作成功時（ダイアログ） |
| 成功 | Comment disapproved | Disapprove操作成功時（ダイアログ） |
| 成功 | Comment deleted | Delete操作成功時（ダイアログ） |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| gcomments権限がない | 権限エラー画面へ転送 | privileges.phtml |

## 備考

- 本画面はAjax読み込みの部分画面のため、レイアウトは無効化されています
- コメント管理画面（No.85）との主な違いは：
  - 特定のコンテンツにフィルタリングされた状態で表示
  - ページネーションなし（全件表示）
  - Ajax操作後にページリロードしない（ajax=1パラメータ）
- 未承認コメントはnotapprovedクラスが付与され、視覚的に区別されます
- 著者名リンクはユーザー編集画面（/admin/users/edit/id/...）に直接遷移します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメント表示画面ではtype/slaveでフィルタリングされたコメントを表示します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | showAction（129-160行目）のクエリ構造を確認 |

**読解のコツ**: type（コンテンツ種別）とslave（コンテンツID）の組み合わせでフィルタリングします。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | showAction（129-160行目）の処理フローを確認 |

**主要処理フロー**:
1. **131行目**: ACLによる権限チェック（gcomments権限）
2. **133行目**: レイアウト無効化
3. **135-136行目**: slave, typeパラメータの取得
4. **141行目**: typeをビュー変数にセット
5. **144-149行目**: comments + usersのJOINクエリ構築
6. **152行目**: 全件取得（ページネーションなし）

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.phtml | `application/modules/admin/views/scripts/comments/show.phtml` | コメント一覧と操作ボタンの構造を確認 |

**主要処理フロー**:
- **9-33行目**: コメント一覧のループ表示
- **11行目**: 未承認コメントのnotapprovedクラス付与
- **12-24行目**: 権限に応じた操作ボタンの表示制御
- **14, 22行目**: ajax=1パラメータ（リロードなし）
- **26行目**: ユーザー編集画面へのリンク

### プログラム呼び出し階層図

```
[ContentPane読み込み: /admin/comments/show/type/.../slave/.../]
    │
    ├─ CommentsController::showAction()
    │      ├─ ACL権限チェック（gcomments）
    │      ├─ レイアウト無効化
    │      ├─ type/slaveパラメータ取得
    │      ├─ SQLクエリ構築（comments JOIN users）
    │      └─ View変数セット（$commentArray）
    │
    └─ show.phtml
           ├─ コメント一覧ループ
           │      ├─ 権限チェック（gcommentsstatus, gcommentdelete）
           │      ├─ 操作ボタン表示（ajax=1）
           │      └─ コメント内容表示
           └─ ユーザー編集リンク

[Approve/Disapprove操作（ajax=1）]
    │
    └─ approveComment(id, status, 1)
           │
           └─ /admin/comments/approve/id/.../status/.../ajax/1/
                  └─ CommentsController::approveAction()
                         ├─ UPDATE comments SET comment_approved = ...
                         └─ ダイアログ表示（リロードなし）

[Delete操作（ajax=1）]
    │
    └─ deleteComment(id, 1)
           │
           └─ /admin/comments/delete/id/.../ajax/1/
                  └─ CommentsController::deleteAction()
                         ├─ DELETE FROM comments WHERE ...
                         └─ ダイアログ表示（リロードなし）
```

### データフロー図

```
[入力]               [処理]                    [出力]

type ─────────────▶ showAction ─────────────▶ コメント一覧HTML
slave ────────────▶      │
(URLパラメータ)          ▼
                   comments + users
                   テーブルJOIN
                   (type/slaveフィルタ)
                          │
                          ▼
                   show.phtml ───────────────▶ 部分HTML
                          │
        ┌─────────────────┼─────────────────┐
        ▼                 ▼                 ▼
   Approve           Disapprove          Delete
   (ajax=1)          (ajax=1)            (ajax=1)
        │                 │                 │
        ▼                 ▼                 ▼
   ダイアログのみ    ダイアログのみ    ダイアログのみ
   （リロードなし）  （リロードなし）  （リロードなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | showAction |
| show.phtml | `application/modules/admin/views/scripts/comments/show.phtml` | ビュー | コメント一覧テンプレート |
| comments.js | `public/_scripts/admin/comments.js` | JavaScript | approveComment, deleteComment関数 |
| details.phtml | `application/modules/admin/views/scripts/articles/details.phtml` | ビュー | 呼び出し元（記事詳細） |
| details.phtml | `application/modules/admin/views/scripts/pages/details.phtml` | ビュー | 呼び出し元（ページ詳細） |
