# 画面設計書 87-ローテーター管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面のローテーター管理画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、CMSで使用する画像ローテーター（スライドショー）の一覧を表示・管理するための画面です。サイトのトップページやバナーエリアで表示される画像スライドショーの設定を管理できます。

**業務上の目的・背景**：Webサイトのトップページや特定のエリアに、複数の画像を自動的に切り替えて表示するローテーター（スライダー/カルーセル）を設置することがあります。本画面は、これらのローテーターの一覧を表示し、各ローテーターの基本設定（サイズ、遅延時間、ページング有無）を確認できます。ローテーターの詳細編集画面への導線を提供し、スライドの追加・編集・削除作業を効率化します。

**画面へのアクセス方法**：管理画面のメニューから「Rotators」を選択することでアクセスできます。管理ダッシュボードからもリンクされています。

**主要な操作・処理内容**：
1. ローテーター一覧の表示（ページネーション付き、15件/ページ）
2. 各ローテーターの基本情報表示（名前、サイズ、スライド数、ページング、遅延時間）
3. ローテーター編集画面への遷移

**画面遷移**：
- 遷移元：管理ダッシュボード、管理メニュー
- 遷移先：ローテーター編集画面

**権限による表示制御**：rotrotators権限を持つユーザーのみがこの画面にアクセスできます。権限がない場合は権限エラー画面へ転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | ローテーター一覧表示 | 主機能 | ローテーター一覧を表示 |
| 62 | ページネーション | 補助機能 | ローテーター一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

一覧

## URL/ルーティング

```
/admin/rotators/
/admin/rotators/manage/
/admin/rotators/manage/page/{page}/
```

| パラメータ | 説明 | 必須 | 例 |
|-----------|------|------|-----|
| page | ページ番号 | No | 1 |

## 入出力項目

### URL パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ページ番号 | page | integer | No | ページネーション用（デフォルト: 1） |

## 表示項目

### ローテーター一覧

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| ローテーター名 | Rotator | rot_name | リンク | 編集画面へのリンク |
| サイズ | Dimensions | rot_width x rot_height | テキスト | 幅 x 高さ（px） |
| スライド数 | Slides | rotSlideCount() | 数値 | 含まれるスライドの件数 |
| ページング | Paging | rot_paging | アイコン | Y=有効/N=無効 |
| 遅延時間 | Delay | rot_delay | 数値 | スライド切替間隔（ミリ秒） |

### 操作リンク（マウスオーバー時表示）

| 操作 | URL | 説明 |
|------|-----|------|
| Edit | /admin/rotators/edit/id/{rot_id}/ | ローテーター編集画面へ |

## イベント仕様

### 1-ローテーター名クリック

**トリガー**：ローテーター名リンクをクリック

**処理内容**：
1. ローテーター編集画面へ遷移

**画面遷移**：/admin/rotators/edit/id/{rot_id}/

### 2-Editリンククリック

**トリガー**：マウスオーバーで表示されるEditリンクをクリック

**処理内容**：
1. ローテーター編集画面へ遷移

**画面遷移**：/admin/rotators/edit/id/{rot_id}/

### 3-ページネーション操作

**トリガー**：ページ番号リンクをクリック

**処理内容**：
1. 指定されたページ番号でURLを更新
2. 該当ページのローテーター一覧を表示

**画面遷移**：/admin/rotators/manage/page/{page}/

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | rotators | SELECT | ローテーター一覧の取得 |
| スライド数表示 | rotators_slides | SELECT | スライド件数の集計 |

### テーブル別更新項目詳細

#### rotators（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rot_id | - | 主キー |
| SELECT | rot_name | - | ローテーター名 |
| SELECT | rot_width | - | 表示幅 |
| SELECT | rot_height | - | 表示高さ |
| SELECT | rot_paging | - | ページング有効/無効 |
| SELECT | rot_delay | - | 切替遅延時間 |

#### rotators_slides（参照のみ - スライド数カウント）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | COUNT(*) | rots_rotator = rot_id | スライド数集計用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No Rotators! | ローテーターが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| rotrotators権限がない | 権限エラー画面へ転送 | privileges.phtml |

## 備考

- 本画面はローテーターの一覧表示のみで、新規作成機能は提供していません（ローテーターはシステム設定で定義）
- ページングのY/NはアイコンにMouseover時にツールチップで説明が表示されます
- スライド数はrotSlideCountビューヘルパーで動的に取得されます
- ページネーションは1ページあたり15件、ページレンジは5件です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ローテーター管理ではrotatorsテーブルとrotators_slidesテーブルを使用します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | fetchRotators関数（24-54行目）とテーブル構造を確認 |

**読解のコツ**: rotatorsテーブルがローテーター本体、rotators_slidesテーブルが各スライドの情報を保持します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | manageAction（29-47行目）の処理フローを確認 |

**主要処理フロー**:
1. **31行目**: ACLによる権限チェック（rotrotators権限）
2. **33-34行目**: ページネーションパラメータ設定（15件/ページ、レンジ5）
3. **36行目**: リクエストパラメータの取得
4. **38行目**: Rotatorsモデルのインスタンス化
5. **40行目**: fetchRotatorsでページネーション付き一覧取得

#### Step 3: モデルの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Rotators.php | `application/models/Rotators.php` | fetchRotators関数（24-54行目）のクエリ構築を確認 |

**主要処理フロー**:
- **26-28行目**: rotatorsテーブルからSELECT
- **30-46行目**: ページネーションパラメータの処理
- **48-52行目**: Zend_Paginatorによるページネーション

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/rotators/manage.phtml` | 一覧テーブルとページネーションの構造を確認 |

**主要処理フロー**:
- **30-37行目**: テーブルヘッダー（Rotator, Dimensions, Slides, Paging, Delay）
- **38-57行目**: ローテーター一覧のループ表示
- **41行目**: マウスオーバーでEdit表示（toggleVis）
- **43-44行目**: ローテーター名リンクとEditリンク
- **47行目**: rotSlideCountビューヘルパーでスライド数表示
- **67-71行目**: ページネーションコントロール

### プログラム呼び出し階層図

```
[リクエスト: /admin/rotators/manage/]
    │
    ├─ RotatorsController::manageAction()
    │      ├─ ACL権限チェック（rotrotators）
    │      ├─ ページネーションパラメータ設定
    │      ├─ Rotatorsモデル初期化
    │      └─ fetchRotators() → View変数（$rotatorsArray）
    │
    └─ manage.phtml
           ├─ テーブルヘッダー
           ├─ ローテーター一覧ループ
           │      ├─ ローテーター名リンク
           │      ├─ Dimensions表示
           │      ├─ rotSlideCountヘルパー
           │      ├─ Pagingアイコン
           │      └─ Delay表示
           └─ ページネーションコントロール

[ローテーター名/Editクリック]
    │
    └─ /admin/rotators/edit/id/{rot_id}/
           └─ RotatorsController::editAction()
```

### データフロー図

```
[入力]               [処理]                    [出力]

page ─────────────▶ manageAction ────────────▶ ローテーター一覧
(URLパラメータ)           │
                          ▼
                   Rotators::fetchRotators()
                          │
                          ▼
                   rotatorsテーブル
                   SELECT + ORDER BY
                          │
                          ▼
                   Zend_Paginator
                   (15件/ページ)
                          │
                          ▼
                   manage.phtml ──────────────▶ HTML一覧
                          │
                          ├─ rotSlideCount()
                          │      │
                          │      ▼
                          │  rotators_slides
                          │  COUNT(*)集計
                          │
                          └─ ページネーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | manageAction |
| manage.phtml | `application/modules/admin/views/scripts/rotators/manage.phtml` | ビュー | ローテーター一覧テンプレート |
| Rotators.php | `application/models/Rotators.php` | モデル | ローテーターデータ操作 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | toggleVis関数 |
