# 画面設計書 88-ローテーター編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面のローテーター編集画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、特定のローテーターの詳細情報と、そのローテーターに含まれるスライドの一覧を表示・管理するための画面です。スライドの新規作成、編集、削除のダイアログへの導線を提供します。

**業務上の目的・背景**：ローテーター（スライドショー）は複数のスライド（画像＋タイトル＋キャプション＋リンク）で構成されます。本画面は、ローテーターの基本設定を確認しながら、含まれるスライドを一覧で管理できます。スライドの追加・編集・削除・並び順の確認を行い、フロントエンドでの表示内容を制御します。

**画面へのアクセス方法**：ローテーター管理画面（No.87）からローテーター名またはEditリンクをクリックすることでアクセスします。

**主要な操作・処理内容**：
1. ローテーター基本情報の表示（名前、サイズ、ページング、遅延時間）
2. スライド一覧の表示（画像、タイトル、キャプション、リンク、優先度）
3. 新規スライド作成ダイアログの呼び出し
4. スライド編集ダイアログの呼び出し
5. スライド削除確認ダイアログの呼び出し
6. ローテーター管理画面への戻り

**画面遷移**：
- 遷移元：ローテーター管理画面
- 遷移先：スライド新規作成画面（ダイアログ）、スライド編集画面（ダイアログ）、スライド削除確認（ダイアログ）、ローテーター管理画面

**権限による表示制御**：
- rotrotators権限：画面へのアクセス権限
- rotrotatoredit権限：スライドの編集操作権限

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | ローテーター編集 | 主機能 | ローテーターの編集処理 |
| 63 | 入力検証 | 補助機能 | ローテーターフォームのバリデーション |
| 43 | スライド削除 | 遷移先機能 | スライド削除ダイアログへの遷移 |

## 画面種別

詳細 / 一覧（複合）

## URL/ルーティング

```
/admin/rotators/edit/id/{rot_id}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| id | ローテーターID | Yes |

## 入出力項目

### URL パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ローテーターID | id | integer | Yes | 編集対象のローテーターID |

## 表示項目

### ローテーター詳細情報

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| ローテーター名 | Name: | rot_name | タグ表示 | ローテーターの識別名 |
| サイズ | Dimensions: | rot_width x rot_height | タグ表示 | 幅 x 高さ（px） |
| ページング | Paging: | rot_paging | アイコン | 有効/無効のアイコン |
| 遅延時間 | Delay: | rot_delay | タグ表示 | 切替間隔（ミリ秒） |

### スライド一覧

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| サムネイル | Image | rots_asset | 画像 | 60x60pxサムネイル |
| タイトル | Title | rots_title | リンク | 編集ダイアログへ |
| キャプション | Caption | rots_description | テキスト | スライドの説明文 |
| リンク | Link | rots_link | リンク | クリック時の遷移先URL |
| 優先度 | Priority | rots_order | 数値 | 表示順序（小さいほど先） |

### 機能ボタン

| ボタン | 説明 |
|--------|------|
| New Slide | 新規スライド作成ダイアログを開く |
| Rotators... | ローテーター管理画面へ戻る |

### 操作リンク（マウスオーバー時表示）

| 操作 | URL | 説明 |
|------|-----|------|
| Edit | getDialog('/admin/rotators/slide/id/{rots_id}/','Edit Slide') | スライド編集ダイアログ |
| Delete | getDialog('/admin/rotators/slidedelete/id/{rots_id}/','Delete Slide') | スライド削除確認ダイアログ |

## イベント仕様

### 1-New Slideボタン押下

**トリガー**：「New Slide」ボタンをクリック

**処理内容**：
1. getDialog関数を呼び出し
2. スライド新規作成画面をAjaxダイアログとして表示

**画面遷移**：/admin/rotators/slidenew/rotator/{rot_id}/（ダイアログ）

### 2-Rotators...ボタン押下

**トリガー**：「Rotators...」ボタンをクリック

**処理内容**：
1. goTo関数を呼び出し
2. ローテーター管理画面へ遷移

**画面遷移**：/admin/rotators/

### 3-スライドタイトルクリック

**トリガー**：スライドタイトルリンクをクリック

**処理内容**：
1. getDialog関数を呼び出し
2. スライド編集画面をAjaxダイアログとして表示

**画面遷移**：/admin/rotators/slide/id/{rots_id}/（ダイアログ）

### 4-Editリンククリック

**トリガー**：マウスオーバーで表示されるEditリンクをクリック

**処理内容**：
1. getDialog関数を呼び出し
2. スライド編集画面をAjaxダイアログとして表示

**画面遷移**：/admin/rotators/slide/id/{rots_id}/（ダイアログ）

### 5-Deleteリンククリック

**トリガー**：マウスオーバーで表示されるDeleteリンクをクリック

**処理内容**：
1. getDialog関数を呼び出し
2. スライド削除確認画面をAjaxダイアログとして表示

**画面遷移**：/admin/rotators/slidedelete/id/{rots_id}/（ダイアログ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | rotators | SELECT | ローテーター詳細の取得 |
| 画面表示 | rotators_slides | SELECT | スライド一覧の取得 |

### テーブル別更新項目詳細

#### rotators（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rot_id | = id パラメータ | 主キー |
| SELECT | rot_name | - | ローテーター名 |
| SELECT | rot_width | - | 表示幅 |
| SELECT | rot_height | - | 表示高さ |
| SELECT | rot_paging | - | ページング有効/無効 |
| SELECT | rot_delay | - | 切替遅延時間 |

#### rotators_slides（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rots_id | - | 主キー |
| SELECT | rots_rotator | = rot_id | フィルタ条件 |
| SELECT | rots_title | - | スライドタイトル |
| SELECT | rots_description | - | キャプション |
| SELECT | rots_link | - | リンクURL |
| SELECT | rots_order | - | 優先度（表示順） |
| SELECT | rots_asset | - | 画像アセットキー |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No Slides! | スライドが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| rotrotators権限またはrotrotatoredit権限がない | 権限エラー画面へ転送 | privileges.phtml |
| 指定されたローテーターが存在しない | ローテーター管理画面へリダイレクト | /admin/rotators/ |

## 備考

- 本画面はローテーターの基本設定は表示のみで、編集機能はありません（システム設定で管理）
- スライドの操作（新規作成、編集、削除）はすべてAjaxダイアログで行われます
- スライドのサムネイル画像は60x60pxで表示され、thumbアクションで動的に生成されます
- ページネーションは実装されていますが、スライド数が少ない場合は表示されません

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ローテーター編集画面ではrotatorsテーブルとrotators_slidesテーブルを使用します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | fetchRotator関数（103-116行目）とfetchSlides関数（61-96行目）を確認 |

**読解のコツ**: fetchRotatorで1件のローテーター情報、fetchSlidesで該当ローテーターのスライド一覧を取得します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | editAction（53-80行目）の処理フローを確認 |

**主要処理フロー**:
1. **55行目**: ACLによる権限チェック（rotrotators && rotrotatoredit権限）
2. **57-58行目**: ページネーションパラメータ設定
3. **60行目**: リクエストパラメータの取得
4. **62行目**: idパラメータの取得
5. **64行目**: Rotatorsモデルのインスタンス化
6. **66行目**: fetchRotatorでローテーター情報取得
7. **68-70行目**: 存在チェック（なければリダイレクト）
8. **72行目**: fetchSlidesでスライド一覧取得

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.phtml | `application/modules/admin/views/scripts/rotators/edit.phtml` | 詳細情報とスライド一覧の構造を確認 |

**主要処理フロー**:
- **35-41行目**: Functionsエリア（New Slide、Rotators...ボタン）
- **46-58行目**: Detailsエリア（Name, Dimensions, Paging, Delay）
- **64-71行目**: テーブルヘッダー（Image, Title, Caption, Link, Priority）
- **72-85行目**: スライド一覧のループ表示
- **76行目**: サムネイル画像（60x60px）
- **78-79行目**: タイトルリンクとEdit/Deleteリンク

### プログラム呼び出し階層図

```
[リクエスト: /admin/rotators/edit/id/{rot_id}/]
    │
    ├─ RotatorsController::editAction()
    │      ├─ ACL権限チェック（rotrotators && rotrotatoredit）
    │      ├─ Rotatorsモデル初期化
    │      ├─ fetchRotator() → View変数（$rotatorArray）
    │      ├─ 存在チェック（なければリダイレクト）
    │      └─ fetchSlides() → View変数（$slidesArray）
    │
    └─ edit.phtml
           ├─ Functionsエリア
           │      ├─ New Slideボタン → getDialog('/admin/rotators/slidenew/...')
           │      └─ Rotators...ボタン → goTo('/admin/rotators/')
           ├─ Detailsエリア（タグ表示）
           └─ スライド一覧テーブル
                  ├─ サムネイル（/admin/assets/thumb/...）
                  ├─ タイトルリンク → getDialog('/admin/rotators/slide/...')
                  └─ Edit/Deleteリンク

[各ダイアログ呼び出し]
    │
    ├─ New Slide → slidenewAction → スライド新規作成画面
    ├─ Edit → slideAction → スライド編集画面
    └─ Delete → slidedeleteAction → スライド削除確認
```

### データフロー図

```
[入力]               [処理]                    [出力]

rot_id ───────────▶ editAction ──────────────▶ 詳細+一覧HTML
(URLパラメータ)           │
                          ├─ fetchRotator()
                          │      │
                          │      ▼
                          │  rotatorsテーブル
                          │  (1件取得)
                          │
                          └─ fetchSlides()
                                 │
                                 ▼
                           rotators_slidesテーブル
                           (複数件取得)
                                 │
                                 ▼
                           edit.phtml ────────▶ HTML
                                 │
        ┌─────────────────┬──────┴──────┬────────────────┐
        ▼                 ▼             ▼                ▼
   New Slide          Edit          Delete         Rotators...
   (ダイアログ)     (ダイアログ)   (ダイアログ)     (画面遷移)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | editAction |
| edit.phtml | `application/modules/admin/views/scripts/rotators/edit.phtml` | ビュー | ローテーター編集テンプレート |
| Rotators.php | `application/models/Rotators.php` | モデル | ローテーター/スライドデータ操作 |
| slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | ビュー | スライド新規作成ダイアログ |
| slide.phtml | `application/modules/admin/views/scripts/rotators/slide.phtml` | ビュー | スライド編集ダイアログ |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog, goTo関数 |
