# 画面設計書 89-スライド編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面のスライド編集画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ローテーターに含まれる個別のスライドを編集するためのAjaxダイアログ画面です。スライドのタイトル、キャプション、リンクURL、優先度（表示順）、画像を変更できます。

**業務上の目的・背景**：ローテーター内の各スライドは、プロモーションバナーやお知らせとして使用されます。キャンペーンの変更やリンク先の更新など、スライドの内容を随時変更する必要があります。本画面は、既存スライドの情報を効率的に編集できる機能を提供し、サイトのビジュアルコンテンツ管理を支援します。

**画面へのアクセス方法**：ローテーター編集画面（No.88）からスライドのタイトルまたはEditリンクをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. スライドタイトルの編集
2. キャプション（説明文）の編集
3. リンクURLの編集
4. 優先度（表示順）の編集
5. 画像アセットの変更（アセット選択ダイアログ経由）
6. 保存ボタンによる更新実行
7. キャンセルボタンによるダイアログ閉じ

**画面遷移**：
- 遷移元：ローテーター編集画面（ダイアログとして）
- 遷移先：アセット選択ダイアログ（Browse...ボタン）

**権限による表示制御**：
- rotrotators権限：画面へのアクセス権限
- rotrotatoredit権限：スライド編集権限

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | スライド編集 | 主機能 | スライドの編集処理 |
| 63 | 入力検証 | 補助機能 | スライドフォームのバリデーション |
| 31 | アセット選択 | 補助機能 | スライド画像の選択 |

## 画面種別

編集（ダイアログ）

## URL/ルーティング

```
/admin/rotators/slide/id/{rots_id}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| id | スライドID | Yes |

## 入出力項目

### URL パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| スライドID | id | integer | Yes | 編集対象のスライドID |

### フォーム入力項目

| 項目名 | フィールド名 | 型 | 必須 | 初期値 | バリデーション | 説明 |
|--------|-------------|-----|------|--------|----------------|------|
| タイトル | slidetitle | text | Yes | rots_title | NotEmpty | スライドのタイトル |
| キャプション | slidedescription | textarea | No | rots_description | - | スライドの説明文 |
| リンク | slidelink | text | Yes | rots_link | NotEmpty | クリック時の遷移先URL |
| 優先度 | slidepriority | text | Yes | rots_order | NotEmpty, 整数 | 表示順（小さいほど先） |
| 画像 | asset | hidden | Yes | rots_asset | NotEmpty | 画像アセットのキー |

## 表示項目

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| 画像プレビュー | - | rots_asset | 画像 | 180x180pxサムネイル |
| ファイル名 | Image | AssetFileヘルパー | テキスト | 選択中のファイル名（読み取り専用） |

## イベント仕様

### 1-Browse...ボタン押下

**トリガー**：「Browse...」ボタンをクリック

**処理内容**：
1. openAssetMan JavaScript関数を呼び出し
2. アセット選択ダイアログを表示（type='image', method='select', field='asset'）
3. 画像選択後、assetフィールドとプレビュー画像を更新

**画面遷移**：アセット選択ダイアログ（別ウィンドウ/ダイアログ）

### 2-Save（保存）ボタン押下

**トリガー**：「Save」ボタンをクリック

**処理内容**：
1. doDialog JavaScript関数を呼び出し
2. フォームデータをPOST送信
3. サーバー側でバリデーション実行
4. 有効な場合、rotators_slidesテーブルを更新
5. 成功時、完了メッセージを表示

**画面遷移**：成功時はダイアログ内に完了メッセージ表示、Closeボタンでダイアログを閉じてページリロード

### 3-Cancel（キャンセル）ボタン押下

**トリガー**：「Cancel」ボタンをクリック

**処理内容**：
1. dijit.byId('ajaxDialog').hide()を実行
2. ダイアログを非表示にする

**画面遷移**：ダイアログが閉じ、変更なしでローテーター編集画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | rotators_slides | SELECT | スライド情報の取得 |
| Save | rotators_slides | UPDATE | スライド情報の更新 |

### テーブル別更新項目詳細

#### rotators_slides

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rots_id | = id パラメータ | 主キー |
| SELECT | rots_title | - | タイトル初期値 |
| SELECT | rots_description | - | キャプション初期値 |
| SELECT | rots_link | - | リンクURL初期値 |
| SELECT | rots_order | - | 優先度初期値 |
| SELECT | rots_asset | - | 画像アセット初期値 |
| UPDATE | rots_title | slidetitleフォーム値 | タイトル |
| UPDATE | rots_description | slidedescriptionフォーム値 | キャプション |
| UPDATE | rots_link | slidelinkフォーム値 | リンクURL |
| UPDATE | rots_order | slidepriorityフォーム値 | 優先度 |
| UPDATE | rots_asset | assetフォーム値 | 画像アセット |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Slide Saved | 保存成功時（ダイアログ内） |
| エラー | Title is required | タイトル未入力時 |
| エラー | Link is required | リンク未入力時 |
| エラー | Priority is required | 優先度未入力時 |
| エラー | Asset is required | 画像未選択時 |
| プロンプト | Input a title | タイトルフィールドのヒント |
| プロンプト | Input a caption | キャプションフィールドのヒント |
| プロンプト | Input a valid URL | リンクフィールドのヒント |
| プロンプト | Input a valid integer | 優先度フィールドのヒント |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| rotrotators権限またはrotrotatoredit権限がない | 権限エラー画面へ転送 | privileges.phtml |
| バリデーションエラー | エラーメッセージを表示してフォーム再表示 | 同一ダイアログ |

## 備考

- 本画面はAjaxダイアログとして表示されるため、レイアウトは無効化されています
- Dojo Toolkitのdijit.form.FormおよびValidationTextBoxウィジェットを使用しています
- 優先度は整数のみ許可（regExp="^([0-9 ]+)$"）
- 画像プレビューは180x180pxのresizeタイプで表示されます
- アセット選択ダイアログでは画像タイプのみ選択可能（type='image'）
- assetFileフィールドは読み取り専用で、ファイル名表示のみ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スライド編集画面ではrotators_slidesテーブルの1レコードを編集します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | fetchSlide関数（123-136行目）とupdateSlide関数（179-190行目）を確認 |

**読解のコツ**: fetchSlideで1件のスライド情報を取得し、updateSlideで更新処理を行います。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slideAction（171-257行目）の処理フローを確認 |

**主要処理フロー**:
1. **173行目**: ACLによる権限チェック（rotrotators && rotrotatoredit権限）
2. **175行目**: レイアウト無効化
3. **177行目**: idパラメータの取得
4. **179-181行目**: Rotatorsモデルでスライド情報取得（fetchSlide）
5. **183行目**: POSTリクエストの判定
6. **189-215行目**: バリデーション設定（slidetitle, slidedescription, slidelink, slidepriority, asset）
7. **217-219行目**: 入力チェック
8. **221-227行目**: updateSlideでDB更新
9. **229-234行目**: 成功メッセージ表示

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | slide.phtml | `application/modules/admin/views/scripts/rotators/slide.phtml` | フォーム構造と各入力フィールドを確認 |

**主要処理フロー**:
- **9-10行目**: posted='N'チェックとメッセージ表示
- **11-26行目**: Titleフィールド（ValidationTextBox、required）
- **27-40行目**: Captionフィールド（SimpleTextarea）
- **41-55行目**: Linkフィールド（ValidationTextBox、required）
- **56-71行目**: Priorityフィールド（ValidationTextBox、regExp整数）
- **75-79行目**: 画像プレビュー（180x180px）
- **81-96行目**: Imageフィールド（readonly + hidden + Browse...ボタン）
- **100-106行目**: Saveボタン（doDialog関数呼び出し）
- **107-112行目**: Cancelボタン

### プログラム呼び出し階層図

```
[Ajaxリクエスト: /admin/rotators/slide/id/{rots_id}/]
    │
    ├─ RotatorsController::slideAction()
    │      ├─ ACL権限チェック（rotrotators && rotrotatoredit）
    │      ├─ レイアウト無効化
    │      ├─ Rotators::fetchSlide() → View変数（$slideArray）
    │      │
    │      └─ [POST時]
    │             ├─ Zend_Filter_Inputでバリデーション
    │             ├─ Rotators::updateSlide()
    │             └─ 成功メッセージ表示
    │
    └─ slide.phtml
           ├─ RenderMessagesヘルパー
           ├─ フォーム（dijit.form.Form）
           │      ├─ Title（ValidationTextBox）
           │      ├─ Caption（SimpleTextarea）
           │      ├─ Link（ValidationTextBox）
           │      ├─ Priority（ValidationTextBox）
           │      ├─ 画像プレビュー（180x180）
           │      └─ Image（readonly + hidden + Browse...）
           ├─ Saveボタン → doDialog()
           └─ Cancelボタン → dijit.byId('ajaxDialog').hide()

[Browse...ボタンクリック]
    │
    └─ openAssetMan('image', 'select', 'asset')
           └─ アセット選択ダイアログ
                  └─ 選択後、assetフィールド更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

rots_id ──────────▶ slideAction ─────────────▶ 編集フォームHTML
(URLパラメータ)           │
                          ▼
                   Rotators::fetchSlide()
                          │
                          ▼
                   rotators_slidesテーブル
                   (1件取得)
                          │
                          ▼
                   slide.phtml ───────────────▶ フォームHTML

[POSTリクエスト時]
    │
フォームデータ ───▶ slideAction ─────────────▶ 結果HTML
    │                     │
    │                     ├─ Zend_Filter_Input
    │                     │  (バリデーション)
    │                     │
    │                     └─ Rotators::updateSlide()
    │                            │
    │                            ▼
    │                      rotators_slidesテーブル
    │                      UPDATE
    │
    └─ asset ────────────▶ openAssetMan ────────▶ アセット選択
       (Browse...クリック)  (ダイアログ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | slideAction |
| slide.phtml | `application/modules/admin/views/scripts/rotators/slide.phtml` | ビュー | スライド編集フォームテンプレート |
| Rotators.php | `application/models/Rotators.php` | モデル | fetchSlide, updateSlide |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog, openAssetMan関数 |
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | アセット選択処理 |
