# 画面設計書 9-記事一覧画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおける記事一覧画面の設計仕様を定義する。公開中の全記事をページネーション付きで一覧表示し、各種フィルタリングやソート機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：記事一覧画面は、サイトに公開されている全ての記事を閲覧可能な形で一覧表示する機能を提供する。ページネーションにより大量の記事を効率的に閲覧でき、sticky記事の優先表示により重要なコンテンツを目立たせることができる。コンテンツ発見性の向上とユーザーエンゲージメント促進という業務課題を解決する。

**画面へのアクセス方法**：ホーム画面のナビゲーション、記事詳細画面からの「Articles」リンク、またはURLで直接アクセス。URLは`/articles/`または`/articles/index`。

**主要な操作・処理内容**：
1. 公開済み記事の一覧取得（公開日時が現在以前、status='published'）
2. sticky記事優先、公開日時降順でのソート
3. ページネーション表示（設定件数/ページ、ページ範囲5）
4. 各記事のタイトル、著者、公開日、導入文、カテゴリ、タグの表示
5. 記事詳細画面への遷移
6. Atom/RSSフィードへのリンク提供

**画面遷移**：
- 遷移元：ホーム画面、記事詳細画面、カテゴリ別記事一覧、著者別記事一覧、グローバルナビゲーション
- 遷移先：記事詳細画面、カテゴリ別記事一覧画面、著者別記事一覧画面、タグ別記事一覧画面

**権限による表示制御**：
- 本画面は認証状態に関わらず同一の表示内容
- 公開済み記事のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 公開中の記事を一覧表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理 |

## 画面種別

一覧（ページネーション付き）

## URL/ルーティング

- URL: `/articles/` または `/articles/index`
- コントローラー: `ArticlesController`
- アクション: `indexAction`
- モジュール: `default`
- レイアウト: `articles`
- クエリパラメータ: `page`（ページ番号）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| page | URL | int | いいえ | ページ番号（デフォルト:1） |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| articlesArray | 出力 | Zend_Paginator | - | 記事一覧（ページネーション付き） |
| page | 出力 | int | - | 現在のページ番号 |
| params | 出力 | array | - | リクエストパラメータ |

## 表示項目

### 記事一覧（articlesArray）

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| article_id | int | 非表示（リンク用） | 記事ID |
| article_title | string | リンク付きテキスト | 記事タイトル |
| article_intro | text | HTML | 記事導入文 |
| article_content | text | 判定用 | 「Read More」リンク表示判定 |
| article_comments | char(1) | 判定用 | コメントリンク表示判定 |
| article_published | datetime | 日付形式 | 公開日時 |
| user_alias | string | リンク付きテキスト | 著者名（設定による表示制御） |
| acat_title | string | リンク付きテキスト | カテゴリ名 |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ | 現在のページ番号 |
| 前後ページリンク | 前/次ページへの遷移 |
| ページ番号リンク | 直接ページ指定 |

## イベント仕様

### 1-記事タイトルクリック

記事タイトルをクリックすると、該当記事の詳細画面へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/`

### 2-Read Moreクリック

「Read More」リンクをクリックすると、記事詳細画面の続き部分へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#more`
- 条件: article_contentがNULLでない場合のみ表示

### 3-Commentクリック

「Comment」リンクをクリックすると、記事詳細画面のコメントセクションへ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#comment`
- 条件: article_commentsが'Y'の場合のみ表示

### 4-著者名クリック

著者名をクリックすると、該当著者の記事一覧画面へ遷移する。

- 遷移先: `/articles/author/{user_alias}/`
- 条件: articles.iniのshowauthorがtrueの場合のみ表示

### 5-カテゴリ名クリック

カテゴリ名をクリックすると、該当カテゴリの記事一覧画面へ遷移する。

- 遷移先: `/articles/category/{acat_title}/`

### 6-タグクリック

タグをクリックすると、該当タグの記事一覧画面へ遷移する。

- 遷移先: `/articles/tag/{tag_name}/`

### 7-ページネーション操作

ページ番号や前後ボタンをクリックすると、該当ページの記事一覧を表示する。

- 遷移先: `/articles/index/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles | SELECT | 公開済み記事を取得 |
| 画面表示 | articles_categories | SELECT | カテゴリ情報を結合取得 |
| 画面表示 | users | SELECT | 著者情報を結合取得 |

### テーブル別更新項目詳細

#### articles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | article_published <= NOW() AND article_status = 'published' | 公開済み記事のみ |

**取得クエリ条件**:
- `article_published <= NOW()`: 予約投稿対応（公開日時が現在以前）
- `article_status = 'published'`: 公開済み記事のみ
- `ORDER BY article_sticky DESC, article_published DESC`: sticky優先、公開日降順
- ページネーション: articles.iniのrows設定値/ページ

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | No articles have been posted yet | 記事が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データベース接続エラー | システムエラー画面へ遷移 |
| 記事が存在しない場合 | 情報メッセージを表示（エラーにはならない） |

## 備考

- レイアウトは'articles'レイアウトを使用
- articles.iniのrows設定で1ページあたりの表示件数を制御
- Atom/RSSフィードへのリンクがheadタグ内に自動生成
- 著者名表示はarticles.iniのshowauthor設定に依存
- ページ範囲は5固定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、記事データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | articlesテーブル（5-20行目）の全カラム |
| 1-2 | database.sql | `database.sql` | articles_categoriesテーブル（26-30行目） |
| 1-3 | database.sql | `database.sql` | usersテーブル（347-361行目）との著者リレーション |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | init()メソッド（11-22行目）でレイアウト設定 |
| 2-2 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | indexAction()メソッド（27-63行目） |

**主要処理フロー**:
1. **30行目**: setRefer()でセッションに現在URLを保存
2. **33行目**: リクエストパラメータをビューに設定
3. **36-41行目**: ページ番号取得（デフォルト1）
4. **47-53行目**: SQLクエリ構築（articles JOIN categories JOIN users）
5. **56-59行目**: Zend_Paginator設定
6. **62行目**: articlesArrayをビューに設定

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/default/views/scripts/articles/index.phtml` | メインテンプレート。記事一覧とページネーション |
| 3-2 | articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | 記事個別表示テンプレート |

**主要処理フロー**:
- **35-45行目**: articlesArrayの件数に応じて記事一覧またはメッセージを表示
- **37行目**: partialLoopで記事を繰り返し表示
- **39行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
HTTP Request (/articles/)
    |
    +-- ArticlesController::init()
    |       |
    |       +-- articles.ini読み込み
    |       +-- レイアウト設定 ('articles')
    |
    +-- ArticlesController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |       |
    |       +-- 認証状態確認
    |       +-- ACL構築
    |
    +-- ArticlesController::indexAction()
            |
            +-- setRefer() - セッション保存
            +-- ページ番号取得
            +-- $registry->db->select() - SQLクエリ構築
            |       |
            |       +-- FROM articles
            |       +-- JOIN articles_categories
            |       +-- JOIN users
            |       +-- WHERE article_published <= NOW()
            |       +-- WHERE article_status = 'published'
            |       +-- ORDER BY sticky DESC, published DESC
            |
            +-- Zend_Paginator::factory()
            |       |
            |       +-- setCurrentPageNumber()
            |       +-- setItemCountPerPage(articles.rows)
            |       +-- setPageRange(5)
            |
            +-- ビュー変数設定 (articlesArray)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト  ───▶ ArticlesController   ───▶ index.phtml
(/articles/)         ::indexAction()           |
  |                        |                   +──▶ articlelist.phtml
  +-- page            SQL SELECT                    (partialLoop)
                           |                   +──▶ paginationControl
                           ▼                        (ページネーション)
                      articles
                      articles_categories
                      users
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | ソース | 記事関連のコントローラー |
| index.phtml | `application/modules/default/views/scripts/articles/index.phtml` | テンプレート | 記事一覧画面のメインビュー |
| articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | テンプレート | 記事個別表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | テンプレート | ページネーションテンプレート |
| articles.ini | `application/configs/articles.ini` | 設定 | 記事表示設定（rows, showauthor等） |
| database.sql | `database.sql` | スキーマ | articles, articles_categories, usersテーブル定義 |
