# 画面設計書 90-スライド新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面のスライド新規作成画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ローテーターに新規スライドを追加するためのAjaxダイアログ画面です。スライドのタイトル、キャプション、リンクURL、優先度（表示順）、画像を設定して新規登録できます。

**業務上の目的・背景**：ローテーター（スライドショー）を構成するスライドを追加するための画面です。プロモーションバナーや告知画像を新規に追加する際に使用します。各スライドには画像、タイトル、キャプション、リンク先URL、表示優先度を設定でき、これによりフロントエンドのスライドショー表示を制御します。

**画面へのアクセス方法**：ローテーター編集画面（No.88）から「New Slide」ボタンをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. スライドタイトルの入力
2. キャプション（説明文）の入力
3. リンクURLの入力
4. 優先度（表示順）の入力
5. 画像アセットの選択（アセット選択ダイアログ経由）
6. Createボタンによる新規登録実行
7. Cancelボタンによるダイアログ閉じ

**画面遷移**：
- 遷移元：ローテーター編集画面（ダイアログとして）
- 遷移先：アセット選択ダイアログ（Browse...ボタン）

**権限による表示制御**：
- 特別な権限チェックは実装されていない（親画面の権限で制御）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | スライド新規作成 | 主機能 | スライドの新規登録処理 |
| 63 | 入力検証 | 補助機能 | スライドフォームのバリデーション |
| 31 | アセット選択 | 補助機能 | スライド画像の選択 |

## 画面種別

新規作成（ダイアログ）

## URL/ルーティング

```
/admin/rotators/slidenew/rotator/{rot_id}/
```

| パラメータ | 説明 | 必須 |
|-----------|------|------|
| rotator | ローテーターID | Yes |

## 入出力項目

### URL パラメータ

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ローテーターID | rotator | integer | Yes | 追加先のローテーターID |

### フォーム入力項目

| 項目名 | フィールド名 | 型 | 必須 | 初期値 | バリデーション | 説明 |
|--------|-------------|-----|------|--------|----------------|------|
| タイトル | slidetitle | text | Yes | 空 | NotEmpty | スライドのタイトル |
| キャプション | slidedescription | textarea | No | 空 | - | スライドの説明文 |
| リンク | slidelink | text | Yes | 空 | NotEmpty | クリック時の遷移先URL |
| 優先度 | slidepriority | text | Yes | 空 | NotEmpty, 整数 | 表示順（小さいほど先） |
| 画像 | asset | hidden | Yes | 空 | NotEmpty | 画像アセットのキー |

## 表示項目

| 項目名 | 表示名 | データソース | 形式 | 説明 |
|--------|--------|--------------|------|------|
| 画像プレビュー | - | asset | 画像 | 180x180pxサムネイル |
| ファイル名 | Image | AssetFileヘルパー | テキスト | 選択中のファイル名（読み取り専用） |

## イベント仕様

### 1-Browse...ボタン押下

**トリガー**：「Browse...」ボタンをクリック

**処理内容**：
1. openAssetMan JavaScript関数を呼び出し
2. アセット選択ダイアログを表示（type='image', method='select', field='asset'）
3. 画像選択後、assetフィールドとプレビュー画像を更新

**画面遷移**：アセット選択ダイアログ（別ウィンドウ/ダイアログ）

### 2-Create（作成）ボタン押下

**トリガー**：「Create」ボタンをクリック

**処理内容**：
1. doDialog JavaScript関数を呼び出し
2. フォームデータをPOST送信
3. サーバー側でバリデーション実行
4. 有効な場合、rotators_slidesテーブルに新規レコード挿入
5. 成功時、完了メッセージを表示

**画面遷移**：成功時はダイアログ内に完了メッセージ表示、Closeボタンでダイアログを閉じてページリロード

### 3-Cancel（キャンセル）ボタン押下

**トリガー**：「Cancel」ボタンをクリック

**処理内容**：
1. dijit.byId('ajaxDialog').hide()を実行
2. ダイアログを非表示にする

**画面遷移**：ダイアログが閉じ、変更なしでローテーター編集画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create | rotators_slides | INSERT | スライド情報の新規登録 |

### テーブル別更新項目詳細

#### rotators_slides

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | rots_title | slidetitleフォーム値 | タイトル |
| INSERT | rots_rotator | rotatorパラメータ値 | 所属ローテーターID |
| INSERT | rots_description | slidedescriptionフォーム値 | キャプション |
| INSERT | rots_link | slidelinkフォーム値 | リンクURL |
| INSERT | rots_order | slidepriorityフォーム値 | 優先度 |
| INSERT | rots_asset | assetフォーム値 | 画像アセット |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Slide Created | 新規登録成功時（ダイアログ内） |
| エラー | Title is required | タイトル未入力時 |
| エラー | Link is required | リンク未入力時 |
| エラー | Priority is required | 優先度未入力時 |
| エラー | Asset is required | 画像未選択時 |
| プロンプト | Input a title | タイトルフィールドのヒント |
| プロンプト | Input a caption | キャプションフィールドのヒント |
| プロンプト | Input a valid URL | リンクフィールドのヒント |
| プロンプト | Input a valid integer | 優先度フィールドのヒント |

## 例外処理

| 例外条件 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| バリデーションエラー | エラーメッセージを表示してフォーム再表示 | 同一ダイアログ |
| titleがnullの場合 | 例外をスロー（newSlideメソッド内） | Exception |

## 備考

- 本画面はAjaxダイアログとして表示されるため、レイアウトは無効化されています
- Dojo Toolkitのdijit.form.FormおよびValidationTextBoxウィジェットを使用しています
- 優先度は整数のみ許可（regExp="^([0-9 ]+)$"）
- 画像プレビューは180x180pxのresizeタイプで表示されます
- アセット選択ダイアログでは画像タイプのみ選択可能（type='image'）
- assetFileフィールドは読み取り専用で、ファイル名表示のみ
- 権限チェックはslidenewAction内では実装されていない（親画面の権限で制御される前提）
- スライド編集画面（No.89）と同様のフォーム構造を持つ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スライド新規作成画面ではrotators_slidesテーブルに新規レコードを挿入します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | newSlide関数（142-159行目）を確認 |

**読解のコツ**: newSlideメソッドでは、受け取ったパラメータをrotators_slidesテーブルに挿入します。titleがnullの場合は例外をスローします。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slidenewAction（85-166行目）の処理フローを確認 |

**主要処理フロー**:
1. **87行目**: レイアウト無効化
2. **89行目**: rotatorパラメータの取得
3. **91行目**: POSTリクエストの判定
4. **97-123行目**: バリデーション設定（slidetitle, slidedescription, slidelink, slidepriority, asset）
5. **125行目**: Zend_Filter_Inputでバリデーション実行
6. **127行目**: バリデーション結果チェック
7. **129-136行目**: Rotators::newSlide()でDB挿入
8. **138-143行目**: 成功メッセージ表示
9. **147-156行目**: エラー時はフォーム値を再設定

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | フォーム構造と各入力フィールドを確認 |

**主要処理フロー**:
- **9-10行目**: posted='N'チェックとメッセージ表示
- **12-26行目**: Titleフィールド（ValidationTextBox、required）
- **27-40行目**: Captionフィールド（SimpleTextarea）
- **41-55行目**: Linkフィールド（ValidationTextBox、required）
- **56-71行目**: Priorityフィールド（ValidationTextBox、regExp整数）
- **75-79行目**: 画像プレビュー（180x180px）
- **81-96行目**: Imageフィールド（readonly + hidden + Browse...ボタン）
- **100-106行目**: Createボタン（doDialog関数呼び出し）
- **107-112行目**: Cancelボタン

### プログラム呼び出し階層図

```
[Ajaxリクエスト: /admin/rotators/slidenew/rotator/{rot_id}/]
    │
    ├─ RotatorsController::slidenewAction()
    │      ├─ レイアウト無効化
    │      ├─ rotatorパラメータ取得
    │      │
    │      └─ [POST時]
    │             ├─ Zend_Filter_Inputでバリデーション
    │             ├─ Rotators::newSlide()
    │             │      └─ rotators_slidesテーブルINSERT
    │             └─ 成功メッセージ表示
    │
    └─ slidenew.phtml
           ├─ RenderMessagesヘルパー
           ├─ フォーム（dijit.form.Form）
           │      ├─ Title（ValidationTextBox）
           │      ├─ Caption（SimpleTextarea）
           │      ├─ Link（ValidationTextBox）
           │      ├─ Priority（ValidationTextBox）
           │      ├─ 画像プレビュー（180x180）
           │      └─ Image（readonly + hidden + Browse...）
           ├─ Createボタン → doDialog()
           └─ Cancelボタン → dijit.byId('ajaxDialog').hide()

[Browse...ボタンクリック]
    │
    └─ openAssetMan('image', 'select', 'asset')
           └─ アセット選択ダイアログ
                  └─ 選択後、assetフィールド更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

rotator ─────────▶ slidenewAction ──────────▶ 新規作成フォームHTML
(URLパラメータ)           │
                          ▼
                   slidenew.phtml ────────────▶ フォームHTML

[POSTリクエスト時]
    │
フォームデータ ───▶ slidenewAction ──────────▶ 結果HTML
    │                     │
    │                     ├─ Zend_Filter_Input
    │                     │  (バリデーション)
    │                     │
    │                     └─ Rotators::newSlide()
    │                            │
    │                            ▼
    │                      rotators_slidesテーブル
    │                      INSERT
    │
    └─ asset ────────────▶ openAssetMan ────────▶ アセット選択
       (Browse...クリック)  (ダイアログ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | slidenewAction |
| slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | ビュー | スライド新規作成フォームテンプレート |
| Rotators.php | `application/models/Rotators.php` | モデル | newSlide |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog, openAssetMan関数 |
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | アセット選択処理 |
