# 画面設計書 91-管理者エラー画面

## 概要

管理画面において発生したシステムエラー（例外）をユーザーに通知するためのエラー表示画面の設計書。

### 本画面の処理概要

**業務上の目的・背景**：管理画面でアプリケーションエラーやサーバーエラーが発生した場合、システム管理者やコンテンツ編集者に対してエラーが発生したことを明確に通知する必要がある。また、開発・保守担当者がデバッグできるよう、エラーの詳細情報を表示する機能も備えている。この画面により、ユーザーは予期しない問題が発生したことを認識でき、管理者への連絡や再試行といった適切な対応を取ることができる。

**画面へのアクセス方法**：この画面は直接アクセスするものではなく、管理画面内で以下の場合に自動的に表示される。
1. コントローラーまたはアクションが見つからない場合（404エラーとして処理）
2. アプリケーション内部でキャッチされない例外が発生した場合
3. PHPの致命的なエラーやデータベース接続エラーなどのシステムエラーが発生した場合

**主要な操作・処理内容**：
1. エラー種別の判定：Zend Frameworkのエラーハンドラプラグインから渡されたエラー情報に基づき、404エラー（コントローラー・アクション未検出）かアプリケーションエラーかを判定
2. HTTPステータスコードの設定：404エラーの場合は「HTTP/1.1 404 Not Found」をレスポンスヘッダに設定
3. エラータイトルの設定：エラー種別に応じて適切なタイトル（「HTTP/1.1 404 Not Found」または「Application Error」）をビューに渡す
4. エラーメッセージの表示：ユーザー向けのエラーメッセージまたは例外オブジェクトの詳細をビューに表示
5. シンプルなレイアウトでの表示：管理画面のナビゲーションを含まない認証用レイアウト（admin-auth）を使用して、エラー内容を明確に表示

**画面遷移**：
- 遷移元：管理画面内のすべてのページ（エラー発生時に自動転送）
- 遷移先：特になし（エラー状態のため、ユーザーはブラウザの戻るボタンや直接URLアクセスで他ページに移動）

**権限による表示制御**：この画面はエラーハンドリング用であるため、認証状態や権限に関係なく表示される。ただし、preDispatch内で認証状態を確認し、認証済みユーザーの場合はユーザー情報をビューに渡す。未認証の場合はゲストロール（role_id=2）として処理される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | システムエラー発生時のエラーハンドリングと表示 |

## 画面種別

エラー表示

## URL/ルーティング

- **URLパターン**: `/admin/error/error`
- **モジュール**: admin
- **コントローラー**: error
- **アクション**: error
- **自動転送**: Zend_Controller_Plugin_ErrorHandlerプラグインにより、未キャッチ例外発生時に自動的にこのアクションに転送される

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| error_handler | 入力 | object | Yes | Zendエラーハンドラプラグインから渡されるエラー情報オブジェクト |
| error_handler->type | 入力 | string | Yes | エラー種別（EXCEPTION_NO_CONTROLLER, EXCEPTION_NO_ACTION, その他） |
| error_handler->exception | 入力 | Exception | No | 発生した例外オブジェクト |

## 表示項目

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|----------|
| title | string | エラータイトル（「HTTP/1.1 404 Not Found」または「Application Error」） | 常時 |
| message | string/Exception | エラーメッセージまたは例外オブジェクトの詳細 | messageが設定されている場合 |

## イベント仕様

### 1-エラー発生検知

**トリガー**: 管理画面内で例外が発生、またはコントローラー・アクションが見つからない場合

**処理フロー**:
1. Zend_Controller_Plugin_ErrorHandlerがエラーを検知
2. Admin_ErrorControllerのerrorActionに処理を転送
3. setLayout()でレイアウトを「admin-auth」に変更
4. エラー種別を判定:
   - EXCEPTION_NO_CONTROLLER または EXCEPTION_NO_ACTION の場合:
     - HTTPステータスを404に設定
     - タイトルを「HTTP/1.1 404 Not Found」に設定
     - メッセージを「The resource you requested could not be found.」に設定
   - その他のエラーの場合:
     - タイトルを「Application Error」に設定
     - メッセージに例外オブジェクト全体を設定
5. error.phtmlテンプレートでエラー内容を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エラー表示 | - | - | データベース操作なし |

この画面はエラー表示専用であり、データベースへの書き込み操作は行わない。preDispatch内でACL構築のためにusers_roles、users_resources、users_privilegesテーブルからの読み取りが行われるが、これは画面固有の処理ではない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | The resource you requested could not be found. | 404エラー（コントローラー・アクション未検出）の場合 |
| MSG-002 | エラー | {例外オブジェクトの詳細} | アプリケーションエラーの場合（例外のスタックトレース含む） |

## 例外処理

| 例外種別 | 対応 |
|---------|------|
| この画面自体がエラーハンドラ | エラーページの表示に失敗した場合は、PHPの既定エラー処理に委ねられる |

## 備考

- 開発環境では例外の詳細（スタックトレース含む）が表示されるが、本番環境では適切にエラーログに記録し、ユーザーには一般的なエラーメッセージのみ表示することが推奨される
- この画面は認証用の簡素なレイアウト（admin-auth）を使用するため、管理画面のナビゲーションメニューは表示されない
- HTTPステータスコードは適切に設定されるため、検索エンジンのクローラーや監視ツールが正しくエラーを検知できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エラーハンドリングで使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | error_handlerパラメータの構造とエラー種別の定数を確認 |

**読解のコツ**: Zend_Controller_Plugin_ErrorHandler::EXCEPTION_NO_CONTROLLER等の定数はZend Frameworkの組み込み定数であり、エラー種別を示す。

#### Step 2: エントリーポイントを理解する

エラー発生時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | Admin_ErrorControllerクラスの継承関係とerrorActionの処理フローを確認 |

**主要処理フロー**:
1. **行22-42**: errorAction()メソッドがエラーハンドリングの本体
2. **行24**: setLayout()でレイアウトを「admin-auth」に切り替え
3. **行26**: エラーハンドラパラメータを取得
4. **行27-41**: switch文でエラー種別を判定し、適切なタイトルとメッセージを設定

#### Step 3: 基底クラスを理解する

エラーコントローラーの共通処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Error.php | `library/CMS/Controller/Action/Error.php` | CMS_Controller_Action_Errorの継承関係とpreDispatch処理を確認 |

**主要処理フロー**:
- **行17-40**: preDispatch()で認証状態確認とACL構築
- **行23-27**: 認証済みの場合、ユーザー情報とロールをビューに渡す
- **行31-34**: 未認証の場合、ゲストロール（role_id=2）を設定

#### Step 4: ビューテンプレートを理解する

画面の出力内容を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | error.phtml | `application/modules/admin/views/scripts/error/error.phtml` | エラーメッセージの表示方法を確認 |

**主要処理フロー**:
- **行9-14**: ヘッダー情報（CSS、JavaScript、タイトル）の設定
- **行19-24**: メッセージが存在する場合、pre要素内に表示

#### Step 5: レイアウトを理解する

エラー画面のレイアウト構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | admin-auth.phtml | `application/layouts/admin-auth.phtml` | エラー表示用の簡素なレイアウト構造を確認 |

**主要処理フロー**:
- **行46-66**: シンプルなボックスレイアウトでコンテンツを表示
- **行53**: placeholder('title')でエラータイトルを表示
- **行55**: layout()->contentでエラー詳細を表示

### プログラム呼び出し階層図

```
Zend_Controller_Plugin_ErrorHandler（例外検知）
    │
    └─ Admin_ErrorController::errorAction()
           │
           ├─ setLayout() → 'admin-auth'レイアウト適用
           │
           ├─ CMS_Controller_Action_Error::preDispatch()
           │      └─ CMS_Acl_Factory::createGlobalAcl()
           │             └─ DB SELECT (users_roles, users_resources, users_privileges)
           │
           └─ error.phtml（ビューレンダリング）
                  └─ admin-auth.phtml（レイアウト適用）
```

### データフロー図

```
[入力]                     [処理]                              [出力]

例外/エラー発生    ───▶  ErrorHandler Plugin       ───▶  error_handler パラメータ
                         │
                         ▼
error_handler     ───▶  errorAction()             ───▶  title, message
                         │
                         ├─ エラー種別判定
                         │   ├─ 404 → "Not Found"
                         │   └─ Other → "Application Error"
                         │
                         ▼
title, message    ───▶  error.phtml               ───▶  HTMLレスポンス
                         │
                         ▼
HTMLコンテンツ    ───▶  admin-auth.phtml          ───▶  完成したHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | コントローラー | 管理画面エラーハンドリングのメイン処理 |
| Error.php | `library/CMS/Controller/Action/Error.php` | 基底クラス | エラーコントローラー共通の認証・ACL処理 |
| error.phtml | `application/modules/admin/views/scripts/error/error.phtml` | ビューテンプレート | エラーメッセージの表示テンプレート |
| admin-auth.phtml | `application/layouts/admin-auth.phtml` | レイアウト | 認証・エラー画面用の簡素なレイアウト |
| Factory.php | `library/CMS/Acl/Factory.php` | ユーティリティ | ACL（アクセス制御リスト）の構築 |
| template.css | `_styles/admin/template.css` | スタイルシート | 管理画面のスタイル定義 |
| common.js | `_scripts/admin/common.js` | JavaScript | 管理画面の共通スクリプト |
