# 画面設計書 92-管理者404エラー画面

## 概要

管理画面において、要求されたリソース（ページ）が存在しない場合に表示される404エラー画面の設計書。

### 本画面の処理概要

**業務上の目的・背景**：管理画面内で、存在しないURLにアクセスした場合や、削除されたコンテンツを参照しようとした場合に、ユーザーに対して「ページが見つからない」ことを明確に通知する必要がある。この画面により、ユーザーはアクセスしようとしたリソースが存在しないことを認識し、正しいURLの確認や管理画面トップへの移動といった対応を取ることができる。また、HTTPステータスコード404を正しく返すことで、検索エンジンやブックマーク管理ツールに対してもリソースの不在を適切に伝達する。

**画面へのアクセス方法**：この画面は直接アクセスするものではなく、以下の状況で自動的に表示される。
1. 管理画面内で存在しないURLパスにアクセスした場合
2. コントローラー内から明示的に404エラーにフォワードされた場合（例：存在しないIDを指定してコンテンツを参照しようとした場合）
3. データベースから該当レコードが見つからず、コントローラーがnotfoundアクションに転送した場合

**主要な操作・処理内容**：
1. HTTPステータスコードの設定：「HTTP/1.1 404 Not Found」をレスポンスヘッダに設定
2. エラータイトルの設定：「HTTP/1.1 404 Not Found」をビュータイトルとして設定
3. エラーメッセージの設定：「The resource you requested could not be found.」を表示メッセージとして設定
4. シンプルなレイアウトでの表示：管理画面のナビゲーションを含まない認証用レイアウト（admin-auth）を使用してエラー内容を表示
5. ユーザーへの案内：リソースが見つからない旨を明確に伝達

**画面遷移**：
- 遷移元：管理画面内のすべてのページ（存在しないリソースへのアクセス時に自動転送）
- 遷移先：特になし（エラー状態のため、ユーザーはブラウザの戻るボタンや直接URLアクセスで他ページに移動）

**権限による表示制御**：この画面はエラーハンドリング用であるため、認証状態や権限に関係なく表示される。ただし、preDispatch内で認証状態を確認し、認証済みユーザーの場合はユーザー情報をビューに渡す。未認証の場合はゲストロール（role_id=2）として処理される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | ページ未検出エラーの表示 |

## 画面種別

エラー表示

## URL/ルーティング

- **URLパターン**: `/admin/error/notfound`
- **モジュール**: admin
- **コントローラー**: error
- **アクション**: notfound
- **転送方式**: コントローラーから`_forward('notfound','error','admin')`により転送

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| (なし) | - | - | - | このアクションは入力パラメータを必要としない |

## 表示項目

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|----------|
| title | string | エラータイトル（「HTTP/1.1 404 Not Found」） | 常時 |
| message | string | エラーメッセージ（「The resource you requested could not be found.」） | 常時 |

## イベント仕様

### 1-404エラー表示

**トリガー**: 存在しないリソースへのアクセス、または明示的な404転送

**処理フロー**:
1. Admin_ErrorControllerのnotfoundActionが呼び出される
2. setLayout()でレイアウトを「admin-auth」に変更
3. HTTPステータスを「HTTP/1.1 404 Not Found」に設定
4. ビュータイトルを「HTTP/1.1 404 Not Found」に設定
5. ビューメッセージを「The resource you requested could not be found.」に設定
6. notfound.phtmlテンプレートでエラー内容を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 404エラー表示 | - | - | データベース操作なし |

この画面はエラー表示専用であり、データベースへの書き込み操作は行わない。preDispatch内でACL構築のためにusers_roles、users_resources、users_privilegesテーブルからの読み取りが行われるが、これは画面固有の処理ではない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | The resource you requested could not be found. | 常時表示 |

## 例外処理

| 例外種別 | 対応 |
|---------|------|
| この画面自体がエラーハンドラ | 404エラーページの表示に失敗した場合は、PHPの既定エラー処理に委ねられる |

## 備考

- この画面はerrorActionとは独立しており、明示的に404エラーを表示したい場合に使用される
- errorActionも404エラーを処理できるが、notfoundActionはよりシンプルで、コントローラーからの明示的な転送に適している
- HTTPステータスコード404が適切に設定されるため、検索エンジンのクローラーや監視ツールが正しくエラーを検知できる
- この画面は認証用の簡素なレイアウト（admin-auth）を使用するため、管理画面のナビゲーションメニューは表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

この画面では特別なデータ構造は使用されない。固定のメッセージを表示するのみ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | notfoundActionで設定される固定値を確認 |

**読解のコツ**: notfoundActionは非常にシンプルで、固定のHTTPステータス、タイトル、メッセージを設定するのみ。

#### Step 2: エントリーポイントを理解する

404エラー発生時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | Admin_ErrorControllerクラスのnotfoundActionを確認 |

**主要処理フロー**:
1. **行48-55**: notfoundAction()メソッドが404エラーハンドリングの本体
2. **行50**: setLayout()でレイアウトを「admin-auth」に切り替え
3. **行52**: HTTPステータスを「404 Not Found」に設定
4. **行53**: タイトルを「HTTP/1.1 404 Not Found」に設定
5. **行54**: メッセージを「The resource you requested could not be found.」に設定

#### Step 3: 基底クラスを理解する

エラーコントローラーの共通処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Error.php | `library/CMS/Controller/Action/Error.php` | CMS_Controller_Action_Errorの継承関係とpreDispatch処理を確認 |

**主要処理フロー**:
- **行17-40**: preDispatch()で認証状態確認とACL構築
- **行23-27**: 認証済みの場合、ユーザー情報とロールをビューに渡す
- **行31-34**: 未認証の場合、ゲストロール（role_id=2）を設定

#### Step 4: ビューテンプレートを理解する

画面の出力内容を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notfound.phtml | `application/modules/admin/views/scripts/error/notfound.phtml` | エラーメッセージの表示方法を確認 |

**主要処理フロー**:
- **行9-14**: ヘッダー情報（CSS、JavaScript、タイトル）の設定
- **行19-22**: メッセージが存在する場合に表示（error.phtmlとは異なりpreタグなし）

#### Step 5: レイアウトを理解する

エラー画面のレイアウト構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | admin-auth.phtml | `application/layouts/admin-auth.phtml` | エラー表示用の簡素なレイアウト構造を確認 |

**主要処理フロー**:
- **行46-66**: シンプルなボックスレイアウトでコンテンツを表示
- **行53**: placeholder('title')でエラータイトルを表示
- **行55**: layout()->contentでエラー詳細を表示

#### Step 6: 404エラーへの転送方法を理解する

他のコントローラーから404エラーに転送される方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | 各管理コントローラー | `application/modules/admin/controllers/*.php` | _forward()メソッドによる転送パターンを確認 |

**転送パターン例**:
```php
$this->_forward('notfound','error','admin');
```

### プログラム呼び出し階層図

```
リクエスト（存在しないURL / 明示的転送）
    │
    └─ Admin_ErrorController::notfoundAction()
           │
           ├─ setLayout() → 'admin-auth'レイアウト適用
           │
           ├─ CMS_Controller_Action_Error::preDispatch()
           │      └─ CMS_Acl_Factory::createGlobalAcl()
           │             └─ DB SELECT (users_roles, users_resources, users_privileges)
           │
           ├─ setRawHeader('HTTP/1.1 404 Not Found')
           │
           └─ notfound.phtml（ビューレンダリング）
                  └─ admin-auth.phtml（レイアウト適用）
```

### データフロー図

```
[入力]                     [処理]                              [出力]

リクエスト            ───▶  notfoundAction()          ───▶  HTTPステータス: 404
(存在しないURL)              │
                            ├─ 固定値設定
                            │   ├─ title: "HTTP/1.1 404 Not Found"
                            │   └─ message: "The resource..."
                            │
                            ▼
固定値               ───▶  notfound.phtml            ───▶  HTMLレスポンス
                            │
                            ▼
HTMLコンテンツ       ───▶  admin-auth.phtml          ───▶  完成したHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `application/modules/admin/controllers/ErrorController.php` | コントローラー | 管理画面エラーハンドリングのメイン処理 |
| Error.php | `library/CMS/Controller/Action/Error.php` | 基底クラス | エラーコントローラー共通の認証・ACL処理 |
| notfound.phtml | `application/modules/admin/views/scripts/error/notfound.phtml` | ビューテンプレート | 404エラーメッセージの表示テンプレート |
| admin-auth.phtml | `application/layouts/admin-auth.phtml` | レイアウト | 認証・エラー画面用の簡素なレイアウト |
| Factory.php | `library/CMS/Acl/Factory.php` | ユーティリティ | ACL（アクセス制御リスト）の構築 |
| template.css | `_styles/admin/template.css` | スタイルシート | 管理画面のスタイル定義 |
| common.js | `_scripts/admin/common.js` | JavaScript | 管理画面の共通スクリプト |
