---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-ホーム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **registerboxの認証状態による表示切替詳細**：部分テンプレートの実装詳細が未確認
  2. **YouTube動画表示機能の詳細**：youtube.ini設定とビデオ表示ロジックの関連
  3. **タグボックス（TBox）の実装詳細**：ビューヘルパーの実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/IndexController.php` (indexAction: 30-50行目)
- E-02: `application/modules/default/views/scripts/index/index.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/articlelist.phtml` (全体)
- E-04: `library/CMS/Controller/Action/Default.php` (preDispatch: 17-52行目)
- E-05: `database.sql` (articles: 5-20行目, articles_categories: 26-30行目, users: 347-361行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (No.1行)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面No=1の行)
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` (フロントエンド画面遷移図)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最新記事5件を表示する | E-01 (45行目: limit(5,0)) | ○ |
| C-02 | 公開済み記事のみ取得 | E-01 (43行目: article_status = 'published') | ○ |
| C-03 | sticky記事優先でソート | E-01 (44行目: ORDER BY article_sticky DESC) | ○ |
| C-04 | 公開日時降順でソート | E-01 (44行目: article_published DESC) | ○ |
| C-05 | URLは/または/index/index | E-06 (indexAction記載) | ○ |
| C-06 | HomePageローテーター表示 | E-02 (34行目: RenderRotator('HomePage')) | ○ |
| C-07 | 検索ボックス表示 | E-02 (52行目: partial searchbox.phtml) | ○ |
| C-08 | 認証状態による表示切替 | E-02 (54行目: authenticated変数使用) | ○ |
| C-09 | 次回イベント3件表示 | E-02 (56行目: ENextEventsList(true)) | ○ |
| C-10 | タグボックス表示 | E-02 (60行目: TBox()) | ○ |
| C-11 | articlesテーブルから取得 | E-01, E-05 | ○ |
| C-12 | articles_categoriesとJOIN | E-01 (41行目) | ○ |
| C-13 | usersとJOIN | E-01 (42行目) | ○ |
| C-14 | 記事0件時メッセージ表示 | E-02 (42-44行目) | ○ |
| C-15 | Read Moreリンク条件 | E-03 (17行目: article_content != NULL) | ○ |
| C-16 | Commentリンク条件 | E-03 (20行目: article_comments == 'Y') | ○ |
| C-17 | preDispatchで認証チェック | E-04 (35-47行目) | ○ |
| C-18 | registerboxの表示内容詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- registerbox.phtmlの実装詳細が未読み込み
  - 候補：`application/modules/default/views/scripts/_partials/registerbox.phtml`
- youtube.iniの設定内容
  - 候補：`application/configs/youtube.ini`
- TBoxビューヘルパーの実装
  - 候補：`application/views/helpers/TBox.php` または類似パス

## 5) リスクフラグ（レビュー観点）
- 0: データベースクエリの構造（低リスク - コード確認済み）
- 0: 画面遷移（低リスク - 画面遷移図と整合）
- 1: 認証状態による表示制御の詳細（中リスク - 部分的確認）
- 0: ページネーション（低リスク - 本画面では使用しないことを確認）

## 6) レビュアーチェックリスト（最小）
- [ ] indexActionのSQLクエリが設計書と一致するか確認
- [ ] 画面表示項目がarticlelist.phtmlのテンプレートと一致するか確認
- [ ] registerbox.phtmlの認証状態による分岐を確認
- [ ] articles.iniのshowauthor設定の影響範囲を確認
- [ ] HomePageローテーターの設定がrotatorsテーブルに存在するか確認
