---
generated_at: 2026-02-11 18:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-アーカイブ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ArticlesController.php` (archiveAction: 178-267行目)
- E-02: `application/modules/default/views/scripts/articles/archive.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/articlelist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (12行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (12行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/articles/archive/{year}/{month}/` | E-01 (185-186行目: getParam('year'), getParam('month')) | ○ |
| C-02 | 年・月パラメータ未指定時404エラーへフォワード | E-01 (260-264行目: _forward('notfound','error','default')) | ○ |
| C-03 | 年のみ指定でも動作する | E-01 (229-258行目: elseif分岐) | ○ |
| C-04 | mktime, getdateで日付情報を変換 | E-01 (199-200行目: mktime, getdate) | ○ |
| C-05 | articlesテーブルとarticles_categoriesテーブルをJOIN | E-01 (210-218行目: join句) | ○ |
| C-06 | usersテーブルとJOIN | E-01 (213行目: join) | ○ |
| C-07 | article_status = 'published'で公開記事のみ取得 | E-01 (215行目: where) | ○ |
| C-08 | article_published <= NOW()で公開日時チェック | E-01 (214行目: where) | ○ |
| C-09 | month(article_published)で月をフィルタ | E-01 (216行目: where('month(article_published) = ?',$month)) | ○ |
| C-10 | year(article_published)で年をフィルタ | E-01 (217行目: where('year(article_published) = ?',$year)) | ○ |
| C-11 | article_sticky降順、article_published降順でソート | E-01 (218行目: order) | ○ |
| C-12 | Zend_Paginatorでページネーション実装 | E-01 (220-224行目: Zend_Paginator::factory) | ○ |
| C-13 | ページ番号デフォルト値は1 | E-01 (189-194行目: if-else文) | ○ |
| C-14 | 見出しは「Archive: {月名} {年}」形式 | E-02 (29行目: h2タグ内) | ○ |
| C-15 | 記事がない場合「There are no articles from this period to display.」表示 | E-02 (43行目: partial info.phtml) | ○ |
| C-16 | partialLoopでarticlelist.phtmlを呼び出し | E-02 (37行目: partialLoop) | ○ |
| C-17 | 関連機能は記事一覧表示(5)、ページネーション(62) | E-05 (画面No.12の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] archiveActionのSQLクエリが設計書記載通りか確認
- [ ] mktime, getdateによる日付変換処理の動作確認
- [ ] 年のみ指定時の動作確認
- [ ] 不正な年月パラメータに対するエラーハンドリング確認
