---
generated_at: 2026-02-11 18:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-記事詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ArticlesController.php` (articleAction: 272-369行目)
- E-02: `application/modules/default/views/scripts/articles/article.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/commentform.phtml` (全体)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (13行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (13行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/articles/article/{id}/{title}/` | E-01 (279行目: getParam('id')) | ○ |
| C-02 | 記事ID未指定時404エラーへフォワード | E-01 (363-367行目: _forward('notfound')) | ○ |
| C-03 | articlesテーブルとarticles_categoriesテーブルをJOIN | E-01 (289行目: join) | ○ |
| C-04 | usersテーブルとJOIN | E-01 (290行目: join) | ○ |
| C-05 | users_profilesテーブルとJOIN | E-01 (291行目: join) | ○ |
| C-06 | article_status = 'published'で公開記事のみ取得 | E-01 (293行目: where) | ○ |
| C-07 | article_published <= NOW()で公開日時チェック | E-01 (292行目: where) | ○ |
| C-08 | limit(1,0)で1件取得 | E-01 (295行目: limit) | ○ |
| C-09 | 記事が存在しない場合404エラーへフォワード | E-01 (304-308行目: _forward('notfound')) | ○ |
| C-10 | POSTリクエスト時にコメント処理実行 | E-01 (313行目: isPost()) | ○ |
| C-11 | ログインユーザーのみコメント投稿可能 | E-01 (314行目: $this->view->authenticated) | ○ |
| C-12 | コメント内容にStringTrim, StripTagsフィルタ適用 | E-01 (317-318行目: filters) | ○ |
| C-13 | コメント内容が空の場合エラー「You did not enter a comment」 | E-01 (325行目: messages) | ○ |
| C-14 | article_moderate='Y'時はcomment_approved='N'で登録 | E-01 (337-341行目: if-else) | ○ |
| C-15 | commentsテーブルにINSERT | E-01 (354行目: insert) | ○ |
| C-16 | comment_typeは'A'（記事） | E-01 (345行目: comment_type) | ○ |
| C-17 | 著者情報はshowauthor設定で表示制御 | E-02 (71,38行目: $registry->articles->showauthor) | ○ |
| C-18 | 著者紹介文はBBCodeヘルパーで整形 | E-02 (78行目: $this->BBCode) | ○ |
| C-19 | コメント一覧はAjax（dijit.layout.ContentPane）で取得 | E-02 (96行目: dojoType="dijit.layout.ContentPane") | ○ |
| C-20 | コメント取得先は/comments/comments/type/A/slave/{id}/ | E-02 (96行目: href) | ○ |
| C-21 | コメントフォームはarticle_comments='Y'時のみ表示 | E-02 (104行目: if) | ○ |
| C-22 | ソーシャルシェアはAddThis使用 | E-02 (51-55行目: addthis_button) | ○ |
| C-23 | 未ログイン時は「Please login or register to post a comment」表示 | E-03 (40行目: cInfo) | ○ |
| C-24 | 権限なし時は「You don't have permission to post a comment」表示 | E-03 (34行目: cInfo) | ○ |
| C-25 | 関連機能は記事一覧表示(5)、コメント一覧表示(44)、タグ一覧表示(49)、添付ファイル一覧表示(54) | E-04 (画面No.13の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] articleActionのSQLクエリが設計書記載通りか確認
- [ ] コメント投稿時のバリデーション処理を確認
- [ ] コメント承認制（article_moderate）の動作確認
- [ ] Ajax経由のコメント一覧取得が正常に動作するか確認
- [ ] 権限チェック（gcommentnew）の動作確認
