---
generated_at: 2026-02-11 18:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-タグ別記事一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ArticlesController.php` (tagAction: 383-420行目)
- E-02: `application/modules/default/views/scripts/articles/tag.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/articlelist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (14行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (14行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/articles/tag/{variable}/` | E-01 (396行目: urldecode($this->_request->getParam('variable'))) | ○ |
| C-02 | tagsテーブルからクエリ開始 | E-01 (402行目: from('tags')) | ○ |
| C-03 | articlesテーブルとtag_slave=article_idでJOIN | E-01 (404行目: join('articles', 't.tag_slave = a.article_id')) | ○ |
| C-04 | articles_categoriesテーブルとJOIN | E-01 (405行目: join) | ○ |
| C-05 | usersテーブルとJOIN | E-01 (406行目: join) | ○ |
| C-06 | article_status = 'published'で公開記事のみ取得 | E-01 (407行目: where) | ○ |
| C-07 | tag_tag = タグ名で絞り込み | E-01 (408行目: where('t.tag_tag = ?',$tag)) | ○ |
| C-08 | tag_type = 'A'で記事タグのみ取得 | E-01 (409行目: where('t.tag_type = ?','A')) | ○ |
| C-09 | article_sticky降順、article_published降順でソート | E-01 (410行目: order) | ○ |
| C-10 | Zend_Paginatorでページネーション実装 | E-01 (412-416行目: Zend_Paginator::factory) | ○ |
| C-11 | ページ番号デフォルト値は1 | E-01 (389-394行目: if-else文) | ○ |
| C-12 | 見出しは「Tag: {タグ名}」形式 | E-02 (27行目: h2タグ内) | ○ |
| C-13 | BlogタブとPagesタブの切り替えがある | E-02 (30-33行目: tabBGroup) | ○ |
| C-14 | ATagCount, PTagCountでタグ件数を表示 | E-02 (31-32行目: $this->ATagCount, $this->PTagCount) | ○ |
| C-15 | 記事がない場合「This tag has no associated articles」表示 | E-02 (45行目: partial info.phtml) | ○ |
| C-16 | 関連機能は記事一覧表示(5)、タグ一覧表示(49)、ページネーション(62) | E-05 (画面No.14の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] tagActionのSQLクエリが設計書記載通りか確認
- [ ] tagsテーブルとarticlesテーブルのJOIN条件を確認
- [ ] ATagCount, PTagCountヘルパーの実装を確認
- [ ] タグ名のURLエンコード/デコード処理を確認
