---
generated_at: 2026-02-11 18:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-記事タグ一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ArticlesController.php` (tagsAction: 374-378行目)
- E-02: `application/modules/default/views/scripts/articles/tags.phtml` (全体)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (15行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (15行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/articles/tags/` | E-04 (15行目: tagsAction) | ○ |
| C-02 | tagsActionでsetRefer()を呼び出し | E-01 (377行目: $this->setRefer()) | ○ |
| C-03 | 見出しは「Tags: Blog」固定 | E-02 (28行目: h2タグ内) | ○ |
| C-04 | All/Blog/Pagesの3タブがある | E-02 (31-34行目: tabBGroup) | ○ |
| C-05 | AllタブはTCount('ALL','ALL')で件数表示 | E-02 (32行目: $this->TCount) | ○ |
| C-06 | BlogタブはATagCount('ALL')で件数表示 | E-02 (33行目: $this->ATagCount) | ○ |
| C-07 | PagesタブはPTagCount('ALL')で件数表示 | E-02 (34行目: $this->PTagCount) | ○ |
| C-08 | Blogタブがアクティブ状態 | E-02 (33行目: class="BTab active") | ○ |
| C-09 | タグクラウドはATagCloud('articles','ALL')で生成 | E-02 (41行目: $this->ATagCloud) | ○ |
| C-10 | showTagsプレースホルダーを'false'に設定 | E-02 (21行目: placeholder('showTags')->set('false')) | ○ |
| C-11 | Allタブは/tags/へのリンク | E-02 (32行目: href) | ○ |
| C-12 | 関連機能はタグ一覧表示(49) | E-03 (画面No.15の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] ATagCloudヘルパーの実装を確認（タグクラウド生成ロジック）
- [ ] TCount, ATagCount, PTagCountヘルパーの実装を確認
- [ ] showTagsプレースホルダーの動作確認（サイドバーとの重複抑制）
