---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-イベント一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` (indexAction: 28-60行目)
- E-02: `application/modules/default/views/scripts/events/index.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/eventlist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (16行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (16行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/events/` | E-06 (16行目: indexAction) | ○ |
| C-02 | eventsテーブルからクエリ開始 | E-01 (44行目: from('events')) | ○ |
| C-03 | events_venuesテーブルとJOIN | E-01 (46行目: join) | ○ |
| C-04 | events_categoriesテーブルとJOIN | E-01 (47行目: join) | ○ |
| C-05 | event_status = 'published'で公開イベントのみ取得 | E-01 (48行目: where) | ○ |
| C-06 | event_date >= NOW()で今後のイベントのみ取得 | E-01 (49行目: where) | ○ |
| C-07 | event_date昇順でソート | E-01 (50行目: order('e.event_date ASC')) | ○ |
| C-08 | Zend_Paginatorでページネーション実装 | E-01 (53-56行目: Zend_Paginator::factory) | ○ |
| C-09 | ページ番号デフォルト値は1 | E-01 (34-39行目: if-else文) | ○ |
| C-10 | タイトルは「Events」固定 | E-02 (33行目: h2タグ内) | ○ |
| C-11 | RenderRotator('EventsIndex')でローテーター表示 | E-02 (38行目: $this->RenderRotator) | ○ |
| C-12 | 地図用divのid="map" | E-02 (40行目: id="map") | ○ |
| C-13 | venue_id != 1の場合のみ会場情報表示 | E-03 (10行目: if条件) | ○ |
| C-14 | イベント行クリックでgoTo()呼び出し | E-03 (9行目: onclick="goTo()") | ○ |
| C-15 | イベントがない場合「No events to display at the moment」表示 | E-02 (59行目: partial info.phtml) | ○ |
| C-16 | 関連機能はイベント一覧表示(21)、ページネーション(62) | E-05 (画面No.16の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] indexActionのSQLクエリが設計書記載通りか確認
- [ ] Google Maps連携のJavaScriptファイル（eventsmap.js）の動作確認
- [ ] RenderRotatorヘルパーの実装を確認
- [ ] venue_id = 1 の特殊処理を確認
