---
generated_at: 2026-02-11 19:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-カレンダー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` (calendarAction: 65-155行目)
- E-02: `application/modules/default/views/scripts/events/calendar.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/eventlist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (17行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (17行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/events/calendar/{year}/{month}/{day}/` | E-01 (72-76行目: getParam) | ○ |
| C-02 | 年・月・日パラメータで期間を指定 | E-01 (85,109,131行目: 条件分岐) | ○ |
| C-03 | 年パラメータ未指定時404エラーへフォワード | E-01 (151-154行目: _forward('notfound')) | ○ |
| C-04 | mktime, getdateで日付情報を変換 | E-01 (86-87行目: mktime, getdate) | ○ |
| C-05 | eventsテーブルとevents_venuesテーブルをJOIN | E-01 (93行目: join) | ○ |
| C-06 | events_categoriesテーブルとJOIN | E-01 (94行目: join) | ○ |
| C-07 | event_status = 'published'で公開イベントのみ取得 | E-01 (95行目: where) | ○ |
| C-08 | month(event_date)で月をフィルタ | E-01 (96行目: where('month(event_date) = ?')) | ○ |
| C-09 | dayofmonth(event_date)で日をフィルタ | E-01 (97行目: where('dayofmonth(event_date) = ?')) | ○ |
| C-10 | year(event_date)で年をフィルタ | E-01 (98行目: where('year(event_date) = ?')) | ○ |
| C-11 | event_date昇順でソート | E-01 (99行目: order('e.event_date ASC')) | ○ |
| C-12 | Zend_Paginatorでページネーション実装 | E-01 (101-105行目: Zend_Paginator::factory) | ○ |
| C-13 | ページ番号デフォルト値は1 | E-01 (78-83行目: if-else文) | ○ |
| C-14 | 見出しは「Calendar: {日} {月名} {年}」形式 | E-02 (29行目: h2タグ内) | ○ |
| C-15 | イベントがない場合「No events to display at the moment」表示 | E-02 (47行目: partial info.phtml) | ○ |
| C-16 | partialLoopでeventlist.phtmlを呼び出し | E-02 (37行目: partialLoop) | ○ |
| C-17 | 関連機能はイベント一覧表示(21) | E-05 (画面No.17の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] calendarActionのSQLクエリが設計書記載通りか確認
- [ ] 年のみ、年月、年月日の3パターンの動作確認
- [ ] mktime, getdateによる日付変換処理の動作確認
- [ ] 不正な日付パラメータに対するエラーハンドリング確認
