---
generated_at: 2026-02-11 19:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-イベント詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` (eventAction: 160-254行目)
- E-02: `application/modules/default/views/scripts/events/event.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/commentform.phtml` (全体)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (18行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (18行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/events/event/{id}/{title}/` | E-01 (167行目: getParam('id')) | ○ |
| C-02 | イベントID未指定時404エラーへフォワード | E-01 (249-252行目: _forward('notfound')) | ○ |
| C-03 | eventsテーブルとevents_venuesテーブルをJOIN | E-01 (173行目: join) | ○ |
| C-04 | events_categoriesテーブルとJOIN | E-01 (174行目: join) | ○ |
| C-05 | event_status = 'published'で公開イベントのみ取得 | E-01 (175行目: where) | ○ |
| C-06 | limit(1,0)で1件取得 | E-01 (177行目: limit) | ○ |
| C-07 | POSTリクエスト時にコメント処理実行 | E-01 (186行目: isPost()) | ○ |
| C-08 | ログインユーザーのみコメント投稿可能 | E-01 (188行目: authenticated) | ○ |
| C-09 | コメント内容にStringTrim, StripTagsフィルタ適用 | E-01 (192-193行目: filters) | ○ |
| C-10 | commentsテーブルにINSERT | E-01 (229行目: insert) | ○ |
| C-11 | comment_typeは'E'（イベント） | E-01 (220行目: comment_type) | ○ |
| C-12 | venue_id != 1の場合のみ地図と会場情報表示 | E-02 (9,93行目: if条件) | ○ |
| C-13 | 地図用JavaScript変数（vlat, vlng, vtitle）を設定 | E-02 (21-23行目: var vlat, vlng, vtitle) | ○ |
| C-14 | EDateヘルパーで日付表示 | E-02 (59行目: $this->EDate) | ○ |
| C-15 | event_urlが設定時「Event Website」リンク表示 | E-02 (67-69行目: if条件) | ○ |
| C-16 | event_ticketsが設定時「Buy Tickets」リンク表示 | E-02 (70-72行目: if条件) | ○ |
| C-17 | ソーシャルシェアはAddThis使用 | E-02 (73-78行目: addthis_button) | ○ |
| C-18 | カテゴリはカテゴリ別イベント一覧へのリンク付き | E-02 (86行目: aタグ) | ○ |
| C-19 | 会場電話番号、メール、URLは設定時のみ表示 | E-02 (118,124,130行目: if条件) | ○ |
| C-20 | コメント一覧はAjax（dijit.layout.ContentPane）で取得 | E-02 (150行目: dojoType) | ○ |
| C-21 | コメント取得先は/comments/comments/type/E/slave/{id}/ | E-02 (150行目: href) | ○ |
| C-22 | コメントフォームはevent_comments='Y'時のみ表示 | E-02 (158行目: if条件) | ○ |
| C-23 | noscriptで地図のJavaScript無効メッセージ表示 | E-02 (105-107行目: noscript) | ○ |
| C-24 | 関連機能はイベント一覧表示(21)、タグ一覧表示(49) | E-04 (画面No.18の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] eventActionのSQLクエリが設計書記載通りか確認
- [ ] コメント投稿時のバリデーション処理を確認
- [ ] venue_id = 1 の特殊処理（会場未設定）を確認
- [ ] Google Maps連携のJavaScriptファイル（eventsvenue.js）の動作確認
- [ ] 外部リンク（event_url, event_tickets）が新しいタブで開くか確認
