---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-カテゴリ別イベント一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` (categoryAction: 259-322行目)
- E-02: `application/modules/default/views/scripts/events/category.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/eventlist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (19行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (19行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/events/category/{category}/` | E-01 (266行目: getParam('category')) | ○ |
| C-02 | カテゴリパラメータ未指定時404エラーへフォワード | E-01 (318-321行目: _forward('notfound')) | ○ |
| C-03 | カテゴリが存在しない場合404エラーへフォワード | E-01 (311-315行目: _forward('notfound')) | ○ |
| C-04 | events_categoriesテーブルからカテゴリ情報取得 | E-01 (278-281行目: from, where) | ○ |
| C-05 | ecat_titleでカテゴリを検索 | E-01 (280行目: where('ecat_title = ?')) | ○ |
| C-06 | eventsテーブルとevents_venuesテーブルをJOIN | E-01 (295行目: join) | ○ |
| C-07 | events_categoriesテーブルとJOIN | E-01 (296行目: join) | ○ |
| C-08 | event_status = 'published'で公開イベントのみ取得 | E-01 (297行目: where) | ○ |
| C-09 | event_date >= NOW()で今後のイベントのみ取得 | E-01 (298行目: where) | ○ |
| C-10 | event_categoryでカテゴリ絞り込み | E-01 (299行目: where('event_category = ?')) | ○ |
| C-11 | event_date昇順でソート | E-01 (300行目: order('e.event_date ASC')) | ○ |
| C-12 | Zend_Paginatorでページネーション実装 | E-01 (302-306行目: Zend_Paginator::factory) | ○ |
| C-13 | ページ番号デフォルト値は1 | E-01 (268-273行目: if-else文) | ○ |
| C-14 | 見出しは「Category: {カテゴリ名}」形式 | E-02 (29行目: h2タグ内) | ○ |
| C-15 | カテゴリ説明は1ページ目かつ設定時のみ表示 | E-02 (32-40行目: if条件) | ○ |
| C-16 | イベントがない場合「No events to display at the moment」表示 | E-02 (55行目: partial info.phtml) | ○ |
| C-17 | 関連機能はイベント一覧表示(21)、イベントカテゴリ管理(26)、ページネーション(62) | E-05 (画面No.19の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] categoryActionのSQLクエリが設計書記載通りか確認
- [ ] カテゴリ説明の表示条件（1ページ目のみ）を確認
- [ ] カテゴリ名のURLエンコード/デコード処理を確認
- [ ] 存在しないカテゴリ名でのエラーハンドリングを確認
