---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：2-タグ一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **TCloudヘルパーの実装詳細**：ビューヘルパーのソースコード未確認
  2. **タグクラウドのフォントサイズ算出ロジック**：詳細実装未確認
  3. **公開済みコンテンツのタグのみ表示される制約**：フィルタリングロジック未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/IndexController.php` (tagsAction: 55-58行目)
- E-02: `application/modules/default/views/scripts/index/tags.phtml` (全体)
- E-03: `database.sql` (tags: 335-341行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (No.2行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面No=2の行)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (フロントエンド画面遷移図)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/tags/または/index/tags | E-04 (tagsAction記載) | ○ |
| C-02 | tagsActionがエントリーポイント | E-01 (55-58行目) | ○ |
| C-03 | setRefer()を実行 | E-01 (57行目) | ○ |
| C-04 | TCount('ALL','ALL')で全タグ件数表示 | E-02 (32行目) | ○ |
| C-05 | ATagCount('ALL')で記事タグ件数表示 | E-02 (33行目) | ○ |
| C-06 | PTagCount('ALL')でページタグ件数表示 | E-02 (34行目) | ○ |
| C-07 | TCloud('ALL','articles','ALL')でタグクラウド生成 | E-02 (41行目) | ○ |
| C-08 | Blogタブは/articles/tags/へ遷移 | E-02 (33行目) | ○ |
| C-09 | Pagesタブは/pages/tags/へ遷移 | E-02 (34行目) | ○ |
| C-10 | SideBarローテーター表示 | E-02 (53行目: RenderRotator('SideBar')) | ○ |
| C-11 | tagsテーブルにtag_type, tag_tag, tag_slaveカラム存在 | E-03 | ○ |
| C-12 | タグクラウドのフォントサイズが使用頻度に応じて変動 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TCloudビューヘルパーの実装詳細
  - 候補：`application/views/helpers/TCloud.php` または類似パス
- TCount, ATagCount, PTagCountビューヘルパーの実装
  - 候補：`application/views/helpers/` ディレクトリ内
- タグの公開状態フィルタリングロジック
  - 候補：ビューヘルパー内のSQLクエリ

## 5) リスクフラグ（レビュー観点）
- 0: 画面遷移先（低リスク - テンプレート内リンク確認済み）
- 1: タグクラウド生成ロジック（中リスク - ヘルパー実装未確認）
- 0: タブメニュー構造（低リスク - テンプレート確認済み）
- 1: 公開コンテンツフィルタ（中リスク - フィルタロジック未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] tagsActionの処理内容が設計書と一致するか確認
- [ ] TCloudヘルパーの実装を確認し、タグクラウド生成ロジックを検証
- [ ] タグの公開状態フィルタリングが正しく行われているか確認
- [ ] タブ切り替え時の遷移先URLが正しいか確認
- [ ] SideBarローテーターがrotatorsテーブルに設定されているか確認
