---
generated_at: 2026-02-11 19:15:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-会場別イベント一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  1. 全項目の根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` (venueAction: 327-389行目)
- E-02: `application/modules/default/views/scripts/events/venue.phtml` (全体)
- E-03: `application/modules/default/views/scripts/_partials/eventlist.phtml` (全体)
- E-04: `application/modules/default/views/scripts/_pagination/default.phtml` (全体)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (20行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (20行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/events/venue/{id}/` | E-01 (335行目: getParam('id')) | ○ |
| C-02 | 会場IDパラメータ未指定時404エラーへフォワード | E-01 (385-388行目: _forward('notfound')) | ○ |
| C-03 | 会場が存在しない場合404エラーへフォワード | E-01 (378-382行目: _forward('notfound')) | ○ |
| C-04 | venue_id = 1（デフォルト会場）の場合404エラー | E-01 (355行目: $venueid != '1') | ○ |
| C-05 | events_venuesテーブルから会場情報取得 | E-01 (347-350行目: from, where, limit) | ○ |
| C-06 | eventsテーブルとevents_venuesテーブルをJOIN | E-01 (362行目: join) | ○ |
| C-07 | events_categoriesテーブルとJOIN | E-01 (363行目: join) | ○ |
| C-08 | event_status = 'published'で公開イベントのみ取得 | E-01 (364行目: where) | ○ |
| C-09 | event_date >= NOW()で今後のイベントのみ取得 | E-01 (365行目: where) | ○ |
| C-10 | event_venueで会場絞り込み | E-01 (366行目: where('event_venue = ?')) | ○ |
| C-11 | event_date昇順でソート | E-01 (367行目: order('e.event_date ASC')) | ○ |
| C-12 | Zend_Paginatorでページネーション実装 | E-01 (370-373行目: Zend_Paginator::factory) | ○ |
| C-13 | ページ番号デフォルト値は1 | E-01 (337-342行目: if-else文) | ○ |
| C-14 | 見出しは「Venue: {会場名}」形式 | E-02 (37行目: h2タグ内) | ○ |
| C-15 | 会場詳細は1ページ目のみ表示 | E-02 (40行目: if ($this->page == '1')) | ○ |
| C-16 | 会場説明は設定時のみ表示 | E-02 (41行目: if ($this->venueArray['venue_description'] != NULL)) | ○ |
| C-17 | 地図用JavaScript変数（vlat, vlng, vtitle）を設定 | E-02 (20-22行目: var vlat, vlng, vtitle) | ○ |
| C-18 | 会場電話、メール、URLは設定時のみ表示 | E-02 (62,68,74行目: if条件) | ○ |
| C-19 | イベントがない場合「No events to display at the moment」表示 | E-02 (99行目: partial info.phtml) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] venueActionのSQLクエリが設計書記載通りか確認
- [ ] venue_id = 1 の特殊処理（デフォルト会場は404）を確認
- [ ] 会場詳細情報の表示条件（1ページ目のみ）を確認
- [ ] Google Maps連携のJavaScriptファイル（eventsvenue.js）の動作確認
- [ ] 会場の電話、メール、URLの条件付き表示を確認
- [ ] 外部リンク（venue_url）が新しいタブで開くか確認
