---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-地図画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **mapdata.phtmlの存在確認**：ファイルが見つからなかった
  2. **InfoBoxライブラリの読み込み元**：コード内で確認できず
  3. **マーカーアイコン・背景画像の実在確認**：ファイル存在確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` - mapAction（394-400行）
- E-02: `application/modules/default/controllers/EventsController.php` - mapdataAction（417-433行）
- E-03: `application/modules/default/views/scripts/events/map.phtml`（1-41行）
- E-04: `public/_scripts/default/eventsmap.js`（1-101行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（21行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（22行目）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「地図画面」である | E-06 | ○ |
| C-02 | URLは /events/map/ である | E-01, E-06 | ○ |
| C-03 | コントローラはEventsController::mapAction | E-01 | ○ |
| C-04 | 関連機能はイベント一覧表示（機能No.21） | E-05 | ○ |
| C-05 | 地図はGoogle Maps APIを使用 | E-03, E-04 | ○ |
| C-06 | Google Maps API v3でハイブリッドマップを表示 | E-04（19行目） | ○ |
| C-07 | Ajaxで /events/mapdata/ からデータを取得 | E-04（27行目） | ○ |
| C-08 | mapdataActionでevents_venuesテーブルを検索 | E-02（427-429行） | ○ |
| C-09 | venue_id != 1 の条件でデフォルト会場を除外 | E-02（429行） | ○ |
| C-10 | マーカークリックでInfoBoxを表示 | E-04（94-98行） | ○ |
| C-11 | InfoBoxライブラリを使用 | E-04（96行） | ○ |
| C-12 | 会場データなし時に「No Events To Display」表示 | E-04（40-58行） | ○ |
| C-13 | 地図コンテナのIDは"map"、高さ480px | E-03（37行） | ○ |
| C-14 | JavaScript無効時のフォールバックメッセージあり | E-03（38行） | ○ |
| C-15 | マーカーアイコンはmapmarker.png | E-04（72行） | ○ |
| C-16 | InfoBox背景はtipbox.gif | E-04（84行） | ○ |
| C-17 | jQuery 1.4.1をGoogle CDNから読み込み | E-04（8行） | ○ |
| C-18 | mapdata.phtmlでXMLレスポンスを生成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- mapdata.phtmlファイルが見つからなかった
  - 候補：`application/modules/default/views/scripts/events/mapdata.phtml` / XMLレスポンス生成テンプレート
  - 備考：mapdataActionでビューをレンダリングしているはずだが、ファイルが確認できなかった

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本設計に関する主張は全て根拠あり
- 1: 中リスク - mapdata.phtmlの存在確認が必要（Ajax通信のレスポンス形式に影響）
- 0: 低リスク - 画像ファイル（mapmarker.png, tipbox.gif）の実在確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] mapdata.phtmlファイルの存在とXML出力形式を確認
- [ ] mapmarker.png, tipbox.gifの画像ファイルが存在することを確認
- [ ] 実際にブラウザで地図が正しく表示されることを確認
- [ ] 会場データがない場合のフォールバック表示を確認
