---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-Ajaxカレンダー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. calGo()関数の実装確認推奨
  3. パフォーマンス観点：各日ごとのDBアクセスの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/EventsController.php` - acalendarAction（405-412行）
- E-02: `application/modules/default/views/scripts/events/acalendar.phtml`（1-9行）
- E-03: `application/modules/default/views/helpers/ECalendar.php`（1-118行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（22行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（23行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「Ajaxカレンダー画面」である | E-05 | ○ |
| C-02 | URLは /events/acalendar/ である | E-01 | ○ |
| C-03 | コントローラはEventsController::acalendarAction | E-01 | ○ |
| C-04 | 関連機能はイベント一覧表示（機能No.21）、API連携 | E-04 | ○ |
| C-05 | disableLayout()でレイアウトを無効化 | E-01（407行） | ○ |
| C-06 | monthとyearパラメータを受け取る | E-01（409-410行） | ○ |
| C-07 | ECalendarヘルパーでカレンダーHTML生成 | E-02, E-03 | ○ |
| C-08 | month/year未設定時は現在日時を使用 | E-03（23-27行） | ○ |
| C-09 | 各日ごとにeventsテーブルをSELECT | E-03（67-76行） | ○ |
| C-10 | event_status='published'で絞り込み | E-03（69行） | ○ |
| C-11 | イベントあり日にリンクを生成 | E-03（79行） | ○ |
| C-12 | Dijit.Tooltipでイベント情報表示 | E-03（80行） | ○ |
| C-13 | "View as list"リンクを生成 | E-03（94行） | ○ |
| C-14 | Previous/Nextボタンを生成 | E-03（96-97行） | ○ |
| C-15 | 前月・翌月の計算ロジックあり | E-03（31-44行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 各日ごとにDBアクセスが発生する設計（最大42回/表示）
- 0: 低リスク - calGo()関数の実装確認（events.jsに存在するはず）
- 0: 低リスク - 12月→1月、1月→12月の年またぎ処理の確認

## 6) レビュアーチェックリスト（最小）
- [ ] calGo()関数がevents.jsに存在することを確認
- [ ] 月送り時のAjax通信が正しく動作することを確認
- [ ] 年またぎ（12月→1月、1月→12月）が正しく処理されることを確認
- [ ] パフォーマンス：イベント数が多い月での表示速度を確認
