---
generated_at: 2026-02-11 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-静的ページ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **コメント一覧表示機能**：画面機能マッピングには記載あるが、テンプレートにコメント表示コードが見当たらない
  2. **TListヘルパーの実装確認**：ファイル存在・実装内容の確認
  3. **page_content のXSS対策**：HTMLとして直接出力されるためセキュリティ確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/PagesController.php` - pageAction（28-59行）
- E-02: `application/modules/default/views/scripts/pages/page.phtml`（1-46行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（23行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（24行目）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「静的ページ画面」である | E-04 | ○ |
| C-02 | URLは /page/{slug}/ である | E-01, E-04 | ○ |
| C-03 | コントローラはPagesController::pageAction | E-01 | ○ |
| C-04 | 関連機能はページ一覧表示（機能No.11） | E-03 | ○ |
| C-05 | pagesテーブルからpage_slug一致で検索 | E-01（43行） | ○ |
| C-06 | page_status='published'で絞り込み | E-01（42行） | ○ |
| C-07 | ページ未存在時は404エラーへフォワード | E-01（55-56行） | ○ |
| C-08 | ページタイトルをh2で表示 | E-02（25行） | ○ |
| C-09 | ページコンテンツをHTMLとして出力 | E-02（32行） | ○ |
| C-10 | 最終更新日をADate形式で表示 | E-02（34行） | ○ |
| C-11 | TListヘルパーでタグ一覧表示 | E-02（41行） | ○ |
| C-12 | page_sectionをプレースホルダーに設定 | E-02（19行） | ○ |
| C-13 | pagesレイアウトを使用 | E-01（22行） | ○ |
| C-14 | Dojoウィジェット（RotatorContainer）をロード | E-02（14行） | ○ |
| C-15 | ページタイトルはエスケープして表示 | E-02（25行: $this->escape） | ○ |
| C-16 | コメント一覧表示機能がある | E-03 | △ |

## 4) 不足情報（Unknown / Missing）
- コメント一覧表示機能について
  - 画面機能マッピングには「コメント一覧表示」が補助機能として記載されている
  - しかしpage.phtmlにはコメント表示のコードが見当たらない
  - 候補：別バージョンのテンプレート / 未実装 / 別ファイルでインクルード

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - page_contentがHTMLとして直接出力されるため、管理画面側でのXSS対策が必須
- 1: 中リスク - コメント機能の有無を確認（画面機能マッピングとの不整合）
- 0: 低リスク - TListヘルパーの実装確認

## 6) レビュアーチェックリスト（最小）
- [ ] page_contentに対するXSS対策が管理画面側で実装されていることを確認
- [ ] コメント一覧表示機能の実装状況を確認（画面機能マッピングとの整合性）
- [ ] TList.phpヘルパーファイルの存在と実装を確認
- [ ] 存在しないスラッグでアクセスした際に404エラーが正しく表示されることを確認
