---
generated_at: 2026-02-11 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：28-購読設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **MSubStatusヘルパーの実装確認**：ファイルの存在と実装内容
  2. **toggleCheckbox関数の実装確認**：user.jsでの実装確認
  3. **DELETE→INSERT方式の整合性**：トランザクション制御の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/SettingsController.php` - subscriptionsAction（279-341行）
- E-02: `application/modules/default/views/scripts/settings/subscriptions.phtml`（1-88行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（28行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（29行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「購読設定画面」である | E-04 | ○ |
| C-02 | URLは /settings/subscriptions/ である | E-01, E-04 | ○ |
| C-03 | コントローラはSettingsController::subscriptionsAction | E-01 | ○ |
| C-04 | 関連機能はメール送信（機能No.59） | E-03 | ○ |
| C-05 | Zend_Auth::hasIdentity()で認証確認 | E-01（284行） | ○ |
| C-06 | 未認証時はloginActionへフォワード | E-01（337-338行） | ○ |
| C-07 | mail_groups SELECTでmgroup_open='Y'条件 | E-01（294行） | ○ |
| C-08 | mgroup_title ASCでソート | E-01（295行） | ○ |
| C-09 | POST時に既存購読をDELETE | E-01（306行） | ○ |
| C-10 | 選択グループをforeachでINSERT | E-01（312-321行） | ○ |
| C-11 | h2見出しは"Account Settings: Subscriptions" | E-02（31行） | ○ |
| C-12 | Subscriptionsタブがアクティブ | E-02（36行） | ○ |
| C-13 | 更新成功時に"Subscriptions Updated"を表示 | E-02（42行） | ○ |
| C-14 | MSubStatusで購読状態確認 | E-02（56行） | ○ |
| C-15 | 購読中は背景色変更（yBGクラス） | E-02（56行） | ○ |
| C-16 | グループタイトルをh4で表示 | E-02（57行） | ○ |
| C-17 | グループ説明を表示 | E-02（58行） | ○ |
| C-18 | チェックボックスにDojo CheckBoxを使用 | E-02（59行） | ○ |
| C-19 | divクリックでtoggleCheckbox呼び出し | E-02（56行） | ○ |
| C-20 | MSubStatusヘルパーが存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MSubStatusヘルパーの実装ファイルが未確認
  - 候補：`application/modules/default/views/helpers/MSubStatus.php`
  - ビューから呼び出されているが、ファイルの存在確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - DELETE→INSERT方式でトランザクション制御がない場合、中間状態が発生する可能性
- 1: 中リスク - MSubStatusヘルパーの存在確認
- 0: 低リスク - toggleCheckbox関数の実装確認（user.jsに存在するはず）

## 6) レビュアーチェックリスト（最小）
- [ ] MSubStatus.phpヘルパーファイルの存在を確認
- [ ] toggleCheckbox関数がuser.jsに存在することを確認
- [ ] 購読設定の更新が正しくDBに反映されることを確認
- [ ] 公開グループがない場合の表示を確認
- [ ] DELETE→INSERT処理でトランザクション制御が必要かどうかを評価
