---
generated_at: 2026-02-11 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-404エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. 実際のHTTPレスポンスコード確認推奨
  3. リンク先（ホーム、お問い合わせ）の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ErrorController.php` - notfoundAction（55-64行）
- E-02: `application/modules/default/controllers/ErrorController.php` - errorAction（24-49行）
- E-03: `application/modules/default/views/scripts/error/notfound.phtml`（1-23行）
- E-04: `application/modules/default/views/scripts/error/error.phtml`（1-23行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（29行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（30行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「404エラー画面」である | E-06 | ○ |
| C-02 | コントローラはErrorController::notfoundAction | E-01 | ○ |
| C-03 | 関連機能はアクセス制御（機能No.61） | E-05 | ○ |
| C-04 | setLayout('main')でmainレイアウト設定 | E-01（57行）, E-02（26行） | ○ |
| C-05 | HTTPステータス404を設定 | E-01（58行）, E-02（32行） | ○ |
| C-06 | タイトルは"We're sorry..." | E-01（59行）, E-02（33行） | ○ |
| C-07 | "The resource you requested could not be found."メッセージ | E-01（60-61行）, E-02（34-35行） | ○ |
| C-08 | "It may have been removed..."補足メッセージ | E-01（61行）, E-02（35行） | ○ |
| C-09 | ホームページへのリンク | E-01（62行）, E-02（36行） | ○ |
| C-10 | お問い合わせへのリンク | E-01（63行）, E-02（37行） | ○ |
| C-11 | errorActionでEXCEPTION_NO_CONTROLLER判定 | E-02（29行） | ○ |
| C-12 | errorActionでEXCEPTION_NO_ACTION判定 | E-02（30行） | ○ |
| C-13 | error.phtmlでタイトルをh2表示 | E-04（16行） | ○ |
| C-14 | error.phtmlでメッセージを条件付き表示 | E-04（17-19行） | ○ |
| C-15 | errorクラスのdivでスタイリング | E-03（15行）, E-04（15行） | ○ |
| C-16 | notfound.phtmlとerror.phtmlは同一構造 | E-03, E-04（比較） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実際のHTTPレスポンスコード404がブラウザに返されることの確認
- 0: 低リスク - ホームページリンク（/）が正しく動作することの確認
- 0: 低リスク - お問い合わせリンク（/contact/）が正しく動作することの確認

## 6) レビュアーチェックリスト（最小）
- [ ] 存在しないURLにアクセスした際にこの画面が表示されることを確認
- [ ] HTTPレスポンスコードが404であることを確認（開発者ツール等で）
- [ ] ホームページリンクが正しく動作することを確認
- [ ] お問い合わせリンクが正しく動作することを確認
