---
generated_at: 2026-02-11 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-システムエラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **例外メッセージのXSSリスク**：$exception->GetMessage()がHTMLとして出力される点
  2. **本番環境でのエラー詳細表示制御**：display_errors設定の確認
  3. **HTTPステータスコードの確認**：500が返されるべきか確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ErrorController.php` - errorAction（24-49行）
- E-02: `application/modules/default/views/scripts/error/error.phtml`（1-23行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（30行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（31行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「システムエラー画面」である | E-04 | ○ |
| C-02 | コントローラはErrorController::errorAction | E-01 | ○ |
| C-03 | 関連機能はアクセス制御（機能No.61） | E-03 | ○ |
| C-04 | setLayout('main')でmainレイアウト設定 | E-01（26行） | ○ |
| C-05 | error_handlerパラメータからエラー情報取得 | E-01（27行） | ○ |
| C-06 | switch文でエラータイプを判定 | E-01（28行） | ○ |
| C-07 | defaultケースでシステムエラー処理 | E-01（39行） | ○ |
| C-08 | タイトルは"This is embarrassing..." | E-01（42行） | ○ |
| C-09 | "The application has encountered the following error:"メッセージ | E-01（43行） | ○ |
| C-10 | $errors->exception->GetMessage()で例外メッセージ取得 | E-01（44行） | ○ |
| C-11 | ホームページへのリンク | E-01（45行） | ○ |
| C-12 | お問い合わせへのリンク | E-01（46行） | ○ |
| C-13 | error.phtmlでタイトルをh2表示 | E-02（16行） | ○ |
| C-14 | errorクラスのdivでスタイリング | E-02（15行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 例外メッセージがHTMLとしてエスケープなしで出力される（XSSリスク、本番環境での情報漏洩リスク）
- 1: 中リスク - HTTPステータスコード500が設定されていない（現在はデフォルトの200が返される可能性）
- 1: 中リスク - 本番環境でのエラー詳細表示制御の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 例外メッセージにXSS脆弱性がないか確認（エスケープ処理の検討）
- [ ] 本番環境でエラー詳細が表示されないことを確認
- [ ] HTTPステータスコード500が返されるべきか検討
- [ ] ホームページリンクが正しく動作することを確認
- [ ] お問い合わせリンクが正しく動作することを確認
