---
generated_at: 2026-02-11 18:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：31-サイト閉鎖画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **config.iniのステータスセクション構造**：設定ファイルが存在しないため、実際の設定構造は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ErrorController.php` (70-82行目)
- E-02: `application/modules/default/views/scripts/error/closed.phtml` (1-31行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (31行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (60行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/error/closed/` である | E-01 (closedAction) | ○ |
| C-02 | タイトルは "Site Temporarily Unavailable" | E-01 (80行目) | ○ |
| C-03 | メッセージはconfig.iniから取得 | E-01 (76-77, 81行目) | ○ |
| C-04 | レイアウトは'main'を使用 | E-01 (79行目), E-01 (15行目 setLayout) | ○ |
| C-05 | 関連機能Noは61（アクセス制御） | E-04 | ○ |
| C-06 | Dojoツールキットがロードされる | E-02 (9-12行目) | ○ |
| C-07 | CSSファイルscreen.cssが読み込まれる | E-02 (17行目) | ○ |
| C-08 | データベースアクセスなし | E-01 (closedAction全体) | ○ |
| C-09 | 認証不要の画面である | E-01 (認証チェックなし) | ○ |
| C-10 | 画面種別はエラー/情報表示 | E-03, E-05 | ○ |
| C-11 | ErrorControllerはCMS_Controller_Action_Errorを継承 | E-01 (9行目) | ○ |
| C-12 | Zend_Registryを使用してサイト設定を取得 | E-01 (72-77行目) | ○ |
| C-13 | 表示項目はタイトルとメッセージのみ | E-02 (24-27行目) | ○ |
| C-14 | エラーメッセージは div.aBox.error.copy 内に表示 | E-02 (23-29行目) | ○ |
| C-15 | config.iniにstatusセクションが存在する | E-01 (76行目で参照) | △ |

## 4) 不足情報（Unknown / Missing）
- config.iniファイル自体が存在しないため、実際のステータスセクションの構造は確認できなかった
  - 候補：application/configs/config.ini / application/configs/application.ini / 他の設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとビューのコードから明確に仕様が読み取れる
- 1: 中リスク - 設定ファイルの実際の構造が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] config.iniファイルの実際の存在と構造を確認
- [ ] サイト閉鎖時の管理画面へのアクセス可否を確認
- [ ] 他のエラー画面との整合性を確認
