---
generated_at: 2026-02-11 18:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-管理ダッシュボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **統計ビューヘルパーの実装詳細**：ヘルパーファイル自体は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/IndexController.php` (1-108行目)
- E-02: `application/modules/admin/views/scripts/index/index.phtml` (1-75行目)
- E-03: `library/CMS/Controller/Action/Admin.php` (1-62行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (33行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (61-63行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/admin/` である | E-01 (indexAction) | ○ |
| C-02 | レイアウトは'admin'を使用 | E-01 (13行目) | ○ |
| C-03 | 認証チェックはpreDispatch()で実行 | E-03 (46-48行目) | ○ |
| C-04 | ACLはCMS_Acl_Factoryで生成 | E-03 (52-53行目) | ○ |
| C-05 | gadmin権限がないと権限エラー画面へ | E-03 (54-56行目) | ○ |
| C-06 | 未認証時はログイン画面へリダイレクト | E-03 (57-58行目) | ○ |
| C-07 | 記事セクションはaarticles権限でガード | E-02 (24行目) | ○ |
| C-08 | コメントセクションはgcomments権限でガード | E-02 (31行目) | ○ |
| C-09 | イベントセクションはeevents権限でガード | E-02 (38行目) | ○ |
| C-10 | 会場リンクはevenues権限でガード | E-02 (41行目) | ○ |
| C-11 | メールセクションはmmail権限でガード | E-02 (45行目) | ○ |
| C-12 | ページセクションはppages権限でガード | E-02 (52行目) | ○ |
| C-13 | ローテーターセクションはrotrotators権限でガード | E-02 (59行目) | ○ |
| C-14 | ユーザーセクションはuusers権限でガード | E-02 (66行目) | ○ |
| C-15 | 各統計はビューヘルパーで生成 | E-02 (28, 35, 42, 49, 56, 63, 70行目) | ○ |
| C-16 | 関連機能No.61, 5, 21 | E-05 | ○ |
| C-17 | ログイン成功後にダッシュボードへリダイレクト | E-03 + Admin_AuthController | ○ |
| C-18 | 統計ヘルパーがデータベースから情報取得 | ビューヘルパーファイル | △ |

## 4) 不足情報（Unknown / Missing）
- ビューヘルパー（aStats, cStats等）の実装ファイルが未確認
  - 候補：application/views/helpers/ / library/CMS/View/Helper/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとビューの実装から明確に仕様が読み取れる
- 0: 低リスク - ACL権限チェックのコードが明確

## 6) レビュアーチェックリスト（最小）
- [ ] 統計ビューヘルパーの実装を確認（データベースクエリの内容）
- [ ] ACLリソース名の定義を確認（CMS_Acl_Factory）
- [ ] 各権限とロールの対応関係を確認
