---
generated_at: 2026-02-11 18:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-管理者ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/AuthController.php` (1-258行目)
- E-02: `application/modules/admin/views/scripts/auth/login.phtml` (1-104行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (34行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (64-65行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/admin/auth/login/` である | E-01 (loginAction) | ○ |
| C-02 | レイアウトは'admin-auth'を使用 | E-01 (22行目) | ○ |
| C-03 | 認証済み時はダッシュボードへリダイレクト | E-01 (47-48行目) | ○ |
| C-04 | 未認証時のlogoutはログイン画面へリダイレクト | E-01 (53-54行目) | ○ |
| C-05 | メールアドレスにStringTrim, StringToLowerフィルタ適用 | E-01 (77-78行目) | ○ |
| C-06 | メールアドレスにNotEmpty, EmailAddressバリデータ適用 | E-01 (81-90行目) | ○ |
| C-07 | パスワードにNotEmpty, StringLength(4)バリデータ適用 | E-01 (91-99行目) | ○ |
| C-08 | Zend_Auth_Adapter_DbTableで認証 | E-01 (109-115行目) | ○ |
| C-09 | パスワードはMD5(サイトキー + パスワード + ソルト) | E-01 (114行目) | ○ |
| C-10 | user_status = 'active' 条件でフィルタ | E-01 (118-119行目) | ○ |
| C-11 | Remember me時はCookieに保存 | E-01 (130-132行目) | ○ |
| C-12 | Cookie有効期限は約3ヶ月（7889231秒） | E-01 (131行目) | ○ |
| C-13 | 認証成功時はダッシュボードへリダイレクト | E-01 (137-138行目) | ○ |
| C-14 | FAILURE_IDENTITY_NOT_FOUND時は"Not Found" | E-01 (141-142行目) | ○ |
| C-15 | FAILURE_CREDENTIAL_INVALID時は"Invalid" | E-01 (143-145行目) | ○ |
| C-16 | Dojoツールキット使用 | E-02 (9-16行目) | ○ |
| C-17 | ValidationTextBoxでメールアドレス入力 | E-02 (33-43, 67-77行目) | ○ |
| C-18 | ValidationTextBoxでパスワード入力 | E-02 (48-56, 80-90行目) | ○ |
| C-19 | CheckBoxでRemember me | E-02 (61, 95行目) | ○ |
| C-20 | Cookie保存時はフォームに自動入力 | E-02 (30-63行目) | ○ |
| C-21 | パスワードリセット画面へのリンクあり | E-02 (62, 96行目) | ○ |
| C-22 | 関連機能No.1（ログイン）, No.63（入力検証） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認可能
- 1: 中リスク（セキュリティ観点）- パスワードのCookie保存は平文で行われている可能性あり（E-01 132行目）

## 6) レビュアーチェックリスト（最小）
- [ ] Cookieに保存されるパスワードの形式（平文かハッシュか）を確認
- [ ] Cookie属性（Secure, HttpOnlyフラグ）の設定を確認
- [ ] MD5ハッシュのセキュリティ強度を評価
