---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-記事編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ArticlesController.php` (55-310行目)
- E-02: `application/modules/admin/views/scripts/articles/edit.phtml` (1-153行目)
- E-03: `application/modules/admin/views/scripts/articles/details.phtml` (1-51行目)
- E-04: `application/models/Articles.php` (181-196, 314-383行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (37行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (72-76行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/admin/articles/edit/id/{id}` である | E-01 (editAction) | ○ |
| C-02 | aarticles + aarticleedit権限で画面アクセス制御 | E-01 (57行目) | ○ |
| C-03 | Articles::fetchArticle()で記事取得 | E-01 (62行目), E-04 (181-196行目) | ○ |
| C-04 | 記事不存在時はmanageへリダイレクト | E-01 (64-66行目) | ○ |
| C-05 | title, category, introduction必須バリデーション | E-01 (138-153行目) | ○ |
| C-06 | saveAction()でAjax保存 | E-01 (123-212行目) | ○ |
| C-07 | publishAction()で公開処理 | E-01 (217-310行目) | ○ |
| C-08 | updateArticleStatus()でステータス更新 | E-01 (259-261行目), E-04 (375-383行目) | ○ |
| C-09 | 公開済み記事は検索インデックス更新 | E-04 (349-367行目) | ○ |
| C-10 | html_entity_decode()でHTMLデコード | E-04 (337-338行目) | ○ |
| C-11 | FCKeditorを使用 | E-02 (40-42, 81-89, 96-104行目) | ○ |
| C-12 | TabContainerでタブ構成 | E-02 (47行目) | ○ |
| C-13 | details.phtmlをContentPaneでAjax読み込み | E-02 (45行目) | ○ |
| C-14 | aarticledelete権限でDeleteボタン表示 | E-03 (39行目) | ○ |
| C-15 | aarticlepublish権限でPublishボタン表示 | E-03 (40-42行目) | ○ |
| C-16 | gcomments権限でCommentsタブ表示 | E-02 (149行目) | ○ |
| C-17 | tagsパーシャルでタグ管理 | E-02 (147行目) | ○ |
| C-18 | commentsパーシャルでコメント管理 | E-02 (150行目) | ○ |
| C-19 | チェックボックス値はY/Nに変換 | E-04 (316-332行目) | ○ |
| C-20 | article_edit = NOW()で更新日時設定 | E-04 (342行目) | ○ |
| C-21 | article_published = NOW()で公開日時設定 | E-04 (379行目) | ○ |
| C-22 | 削除時にタグ・コメント・インデックスも削除 | E-04 (264-271行目) | ○ |
| C-23 | "Article Saved"メッセージ表示 | E-01 (176行目) | ○ |
| C-24 | "Article Published"メッセージ表示 | E-01 (273行目) | ○ |
| C-25 | "Article Deleted"メッセージ表示 | E-01 (93行目) | ○ |
| C-26 | 関連機能No.7, 63, 9, 60, 64 | E-06 | ○ |
| C-27 | 著者名はuser_aliasから表示 | E-03 (20行目) | ○ |
| C-28 | ステータス/日付情報をdetailsで表示 | E-03 (21-28行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認可能
- 1: 中リスク（セキュリティ観点）- html_entity_decode()によるXSS脆弱性の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] FCKeditorのバージョンとセキュリティパッチ適用状況を確認
- [ ] html_entity_decode()のセキュリティリスクを評価
- [ ] 検索インデックス更新のパフォーマンスを確認
