---
generated_at: 2026-02-11 19:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-記事新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ArticlesController.php` (336-402行目)
- E-02: `application/modules/admin/views/scripts/articles/new.phtml` (1-55行目)
- E-03: `application/models/Articles.php` (222-237行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (38行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (77-80行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/admin/articles/new/` である | E-01 (newAction) | ○ |
| C-02 | Ajaxダイアログとして表示 | E-01 (340行目 disableLayout) | ○ |
| C-03 | aarticles + aarticlenew権限で画面アクセス制御 | E-01 (338行目) | ○ |
| C-04 | articletitle, articlecategory必須バリデーション | E-01 (348-358行目) | ○ |
| C-05 | Articles::newArticle()で記事作成 | E-01 (365-370行目) | ○ |
| C-06 | 現在ユーザーを著者として設定 | E-01 (369行目) | ○ |
| C-07 | INSERTデータにtitle, category, user, date, edit | E-03 (225-230行目) | ○ |
| C-08 | article_date = NOW() | E-03 (229行目) | ○ |
| C-09 | article_edit = NOW() | E-03 (230行目) | ○ |
| C-10 | lastInsertId()で新規ID取得 | E-01 (376行目) | ○ |
| C-11 | "Article Created"メッセージ表示 | E-01 (373行目) | ○ |
| C-12 | Continueボタンで編集画面へ遷移 | E-01 (375-376行目) | ○ |
| C-13 | ValidationTextBoxでタイトル入力 | E-02 (14-25行目) | ○ |
| C-14 | FilteringSelectでカテゴリ選択 | E-02 (29-37行目) | ○ |
| C-15 | acatselect()でカテゴリオプション生成 | E-02 (36行目) | ○ |
| C-16 | doDialog()でフォーム送信 | E-02 (46行目) | ○ |
| C-17 | Cancelでダイアログ非表示 | E-02 (52行目) | ○ |
| C-18 | 関連機能No.6, 63, 60, 64 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] acatselect()ビューヘルパーの実装を確認
- [ ] common.jsのgetDialog(), doDialog(), goTo()関数を確認
- [ ] 新規作成時のデフォルト値（status='draft'等）がDB側で設定されていることを確認
