---
generated_at: 2026-02-11 19:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-記事詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ArticlesController.php` (315-331行目)
- E-02: `application/modules/admin/views/scripts/articles/details.phtml` (1-51行目)
- E-03: `application/modules/admin/views/scripts/articles/edit.phtml` (45行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (39行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (81-84行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが `/admin/articles/details` である | E-01 (detailsAction) | ○ |
| C-02 | ContentPaneでAjax読み込み | E-03 (45行目) | ○ |
| C-03 | aarticles + aarticleedit権限で画面アクセス制御 | E-01 (317行目) | ○ |
| C-04 | レイアウト無効化 | E-01 (319行目) | ○ |
| C-05 | Articles::fetchArticle()で記事取得 | E-01 (323-324行目) | ○ |
| C-06 | 著者名はuser_aliasから表示 | E-02 (20行目) | ○ |
| C-07 | ステータスはucwords()で先頭大文字化 | E-02 (21行目) | ○ |
| C-08 | 作成日はMakeDateヘルパーでフォーマット | E-02 (23行目) | ○ |
| C-09 | 公開日はpublished時のみ表示 | E-02 (24-26行目) | ○ |
| C-10 | 最終編集日は常時表示 | E-02 (27行目) | ○ |
| C-11 | SaveボタンでpostDialog() | E-02 (38行目) | ○ |
| C-12 | 保存前にMyFCKObject.UpdateEditorFormValue()呼び出し | E-02 (38行目) | ○ |
| C-13 | Deleteボタンはaarticledelete権限でガード | E-02 (39行目) | ○ |
| C-14 | DeleteボタンでgetDialog() | E-02 (39行目) | ○ |
| C-15 | Publishボタンはstatus != 'published'かつaarticlepublish権限でガード | E-02 (40行目) | ○ |
| C-16 | PublishボタンでgetDialog() | E-02 (41行目) | ○ |
| C-17 | Articles...ボタンでgoTo() | E-02 (43行目) | ○ |
| C-18 | 関連機能No.5, 44, 49, 54 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MakeDateビューヘルパーの日時フォーマットを確認
- [ ] FCKeditorとの連携（UpdateEditorFormValue）が正しく動作することを確認
