---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-ユーザー管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **ページネーション表示範囲5ページ**：設定ファイルに直接記載なし
  2. **メール送信ダイアログのURL仕様**：MailControllerの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/UsersController.php` L72-204（manageAction）
- E-02: `application/modules/admin/views/scripts/users/manage.phtml` L1-171（ビューテンプレート全体）
- E-03: `database.sql` L347-361（usersテーブル定義）
- E-04: `database.sql` L457-477（users_profilesテーブル定義）
- E-05: `database.sql` L576-581（users_rolesテーブル定義）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` L42（画面一覧情報）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L89-91（機能マッピング情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/users/manage/` | E-01 L66-67, E-02 L42 | ○ |
| C-02 | GETパラメータ query, role, status, page | E-01 L81-87 | ○ |
| C-03 | 権限チェック uusers | E-01 L74 | ○ |
| C-04 | unewuser権限でNew Userボタン表示制御 | E-02 L63 | ○ |
| C-05 | urolenew権限でNew Roleボタン表示制御 | E-02 L64 | ○ |
| C-06 | ステータス別フィルタ（active/inactive/suspended） | E-02 L91-93, E-01 L102, L129, L139 | ○ |
| C-07 | ロール別フィルタ | E-01 L101, L115, L128, E-02 L104-109 | ○ |
| C-08 | ページネーション15件/ページ | E-01 L183 | ○ |
| C-09 | ページネーション表示範囲5ページ | E-01 L184 | ○ |
| C-10 | ユーザー一覧は姓でASCソート | E-01 L107, L120, L130等 | ○ |
| C-11 | Guestロール(id=2)はロール一覧に非表示 | E-01 L192 | ○ |
| C-12 | role_id > 3のロールのみ削除可能 | E-02 L107 | ○ |
| C-13 | mmailnew権限でメール送信リンク表示 | E-02 L145, L148 | ○ |
| C-14 | usersテーブルの構造 | E-03 | ○ |
| C-15 | users_profilesテーブルの構造 | E-04 | ○ |
| C-16 | users_rolesテーブルの構造 | E-05 | ○ |
| C-17 | ダイアログ表示にgetDialog関数使用 | E-02 L63, L64, L107, L145 | ○ |
| C-18 | ロール編集画面への遷移URL | E-02 L108 | ○ |
| C-19 | ロール削除確認画面への遷移URL | E-02 L107 | ○ |
| C-20 | ユーザー編集画面への遷移URL | E-02 L144-145 | ○ |
| C-21 | Dojoウィジェット使用（Dialog, Button等） | E-02 L9-19 | ○ |
| C-22 | 権限なし時のprivileges画面転送 | E-01 L200-201 | ○ |
| C-23 | 検索機能（名前、エイリアス、メールアドレス） | E-01 L103-106, L116-119等 | ○ |
| C-24 | ページネーション表示範囲設定 | **根拠なし** | △ |
| C-25 | メール送信ダイアログの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ページネーション表示範囲5ページの設定は、コード内で確認できるが設定ファイルでの定義は未確認
  - 候補：application.ini / config.ini / Bootstrap.php
- メール送信機能の詳細（MailController）は本設計書のスコープ外のため未調査
  - 候補：MailController.php / mail関連ビュー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は高い
- 1: 中リスク - ページネーション設定値の変更可能性（ハードコーディング）

## 6) レビュアーチェックリスト（最小）
- [ ] ページネーション設定（15件/ページ、5ページ範囲）が業務要件と一致するか確認
- [ ] 権限制御（uusers, unewuser, urolenew, uroledelete, mmailnew）の妥当性確認
- [ ] システム既定ロール（role_id <= 3）の削除不可仕様が要件と一致するか確認
- [ ] 検索機能のOR条件（エイリアス、メール、姓、名）の仕様が意図通りか確認
