---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-ユーザー編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Membershipタブの詳細仕様**：ビューファイル内にプレースホルダーのみ存在

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/UsersController.php` L513-553（editAction）
- E-02: `application/modules/admin/controllers/UsersController.php` L345-507（saveAction）
- E-03: `application/modules/admin/views/scripts/users/edit.phtml` L1-299（ビューテンプレート全体）
- E-04: `application/modules/admin/views/scripts/users/details.phtml` L1-47（詳細ビュー）
- E-05: `database.sql` L347-361（usersテーブル）
- E-06: `database.sql` L457-477（users_profilesテーブル）
- E-07: `database.sql` L179-189（mail_groupsテーブル）
- E-08: `database.sql` L195-200（mail_subscriptionsテーブル）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` L43（画面一覧情報）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L92-93（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/users/edit/id/{user_id}/` | E-01 L519, E-03 | ○ |
| C-02 | 権限チェック uusers, uview | E-01 L515 | ○ |
| C-03 | 保存時の権限チェック uusers, uedit | E-02 L347 | ○ |
| C-04 | uedit権限でSaveボタン表示制御 | E-04 L28 | ○ |
| C-05 | ustatus権限でステータスボタン表示制御 | E-04 L29-34 | ○ |
| C-06 | upassword権限でパスワードリセットボタン | E-04 L36-38 | ○ |
| C-07 | gcomments権限でコメントリンク表示 | E-04 L18 | ○ |
| C-08 | Identityセクションのフィールド構成 | E-03 L46-109 | ○ |
| C-09 | Personalセクションのフィールド構成 | E-03 L111-145 | ○ |
| C-10 | Contactセクションのフィールド構成 | E-03 L147-182 | ○ |
| C-11 | Organisationセクションのフィールド構成 | E-03 L184-215 | ○ |
| C-12 | Locationセクションのフィールド構成 | E-03 L217-272 | ○ |
| C-13 | Subscriptionsタブの構成 | E-03 L280-295 | ○ |
| C-14 | Membershipタブ表示条件（user_member='Y'） | E-03 L276-278 | ○ |
| C-15 | saveActionのバリデーションルール | E-02 L362-409 | ○ |
| C-16 | usersテーブル更新処理 | E-02 L419-426 | ○ |
| C-17 | users_profilesテーブル更新処理 | E-02 L429-445 | ○ |
| C-18 | mail_subscriptions再構築処理 | E-02 L447-467 | ○ |
| C-19 | alias重複チェック | E-02 L376-378 | ○ |
| C-20 | email重複チェック | E-02 L383-385 | ○ |
| C-21 | 成功メッセージ「User Saved」 | E-02 L469-474 | ○ |
| C-22 | エラーメッセージ各種 | E-02 L363-399 | ○ |
| C-23 | details.phtmlの非同期読み込み | E-03 L39 | ○ |
| C-24 | 自分自身のステータス変更不可 | E-04 L29 | ○ |
| C-25 | 郵便番号の英国形式バリデーション | E-03 L262 | ○ |
| C-26 | ユーザー不存在時のリダイレクト | E-01 L545-547 | ○ |
| C-27 | upro_date自動更新（NOW()） | E-02 L441 | ○ |
| C-28 | Membershipタブの詳細内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Membershipタブの詳細内容はビュー内に空のContentPaneとして定義されているが、実装内容は未確認
  - 候補：Membershipモジュール / 会員管理関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は非常に高い
- 1: 中リスク - Membershipタブの仕様が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルール（必須/任意、形式）が業務要件と一致するか確認
- [ ] 購読設定の再構築ロジック（全削除→再挿入）が要件と一致するか確認
- [ ] 郵便番号バリデーションが英国形式のみで問題ないか確認
- [ ] Membershipタブの実装状況と要件を確認
- [ ] 自分自身のステータス変更不可の仕様が要件と一致するか確認
