---
generated_at: 2026-02-11 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：43-ユーザー新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **メール送信エラーハンドリング**：try-catch処理の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/UsersController.php` L590-746（newAction）
- E-02: `application/modules/admin/views/scripts/users/new.phtml` L1-127（ビューテンプレート全体）
- E-03: `database.sql` L347-361（usersテーブル）
- E-04: `database.sql` L457-477（users_profilesテーブル）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` L44（画面一覧情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/users/new/` | E-01 L590, E-02 | ○ |
| C-02 | Ajaxダイアログとして表示 | E-01 L595（disableLayout） | ○ |
| C-03 | 権限チェック uusers, unewuser | E-01 L592 | ○ |
| C-04 | POSTパラメータとバリデーション | E-01 L605-652 | ○ |
| C-05 | email重複チェック | E-01 L611-613 | ○ |
| C-06 | alias重複チェック | E-01 L621-623 | ○ |
| C-07 | aliasは英数字3文字以上 | E-01 L616-620 | ○ |
| C-08 | first/lastは英字等3文字以上 | E-01 L628-642 | ○ |
| C-09 | パスワード8文字ランダム生成 | E-01 L656 | ○ |
| C-10 | usersテーブルINSERT | E-01 L663-672 | ○ |
| C-11 | users_profilesテーブルINSERT | E-01 L677-689 | ○ |
| C-12 | user_password = md5(password) | E-01 L666 | ○ |
| C-13 | user_key = md5(email + password) | E-01 L667 | ○ |
| C-14 | user_status = 'active' | E-01 L669 | ○ |
| C-15 | user_mailformat = 'text' | E-01 L671 | ○ |
| C-16 | メール送信処理 | E-01 L691-705 | ○ |
| C-17 | 成功メッセージ表示 | E-01 L706-716 | ○ |
| C-18 | エラー時フォーム再表示・値保持 | E-01 L718-733 | ○ |
| C-19 | Cancelボタンでダイアログ閉じる | E-02 L117-118 | ○ |
| C-20 | CreateボタンでdoDialog呼び出し | E-02 L114-115 | ○ |
| C-21 | フォームフィールド構成 | E-02 L12-107 | ○ |
| C-22 | メール送信エラーハンドリング | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メール送信失敗時のエラーハンドリングの詳細は未確認
  - 候補：Zend_Mail例外処理 / エラーログ出力

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は高い
- 1: 中リスク - メール送信失敗時の振る舞いが不明確
- 1: 中リスク - パスワードのMD5ハッシュのみ使用（セキュリティ面）

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード生成ロジック（8文字ランダム）がセキュリティ要件を満たすか確認
- [ ] MD5ハッシュのみの使用（salt未使用）がセキュリティポリシーと合致するか確認
- [ ] メール送信失敗時のユーザーへの通知方法を確認
- [ ] 新規作成後に即座にactiveとなる仕様が要件と一致するか確認
- [ ] エイリアスの文字数制限（3文字以上）が業務要件と一致するか確認
