---
generated_at: 2026-02-11 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-ロール新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/UsersController.php` L749-818（rolenewAction）
- E-02: `application/modules/admin/views/scripts/users/rolenew.phtml` L1-42（ビューテンプレート全体）
- E-03: `database.sql` L576-581（users_rolesテーブル）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L47（画面一覧情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/users/rolenew/` | E-01, E-02 | ○ |
| C-02 | Ajaxダイアログとして表示 | E-01 L754（disableLayout） | ○ |
| C-03 | 権限チェック uusers, urolenew | E-01 L751 | ○ |
| C-04 | roletitleパラメータ | E-01 L760-771 | ○ |
| C-05 | NotEmptyバリデーション | E-01 L763 | ○ |
| C-06 | Alnum（空白許可）バリデーション | E-01 L764 | ○ |
| C-07 | 重複チェック（NoRecordExists） | E-01 L765 | ○ |
| C-08 | users_roles INSERT | E-01 L778-783 | ○ |
| C-09 | role_colour = '#FFFFFF' | E-01 L781 | ○ |
| C-10 | 成功メッセージ「Role Created」 | E-01 L787 | ○ |
| C-11 | Continueボタンでロール管理画面へ遷移 | E-01 L789-792 | ○ |
| C-12 | エラーメッセージ「Title is required」 | E-01 L768 | ○ |
| C-13 | エラーメッセージ「Invalid Title」 | E-01 L768 | ○ |
| C-14 | エラーメッセージ「Title in use」 | E-01 L768 | ○ |
| C-15 | エラー時フォーム再表示・値保持 | E-01 L800-807, E-02 L36 | ○ |
| C-16 | Cancelボタンでダイアログ閉じる | E-02 L32-33 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は完全

## 6) レビュアーチェックリスト（最小）
- [ ] ロール名の命名規則（英数字・空白のみ）が業務要件と一致するか確認
- [ ] 作成直後のロールに権限がないことの運用影響を確認
- [ ] デフォルト識別色（白）の妥当性を確認
