---
generated_at: 2026-02-11 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：48-イベント管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **EVenueCount/ECategoryCount View Helperの実装詳細**：ビューヘルパーの具体的実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/EventsController.php` L123-194（manageAction）
- E-02: `application/modules/admin/views/scripts/events/manage.phtml` L1-187（ビューテンプレート全体）
- E-03: `database.sql` L103-119（eventsテーブル）
- E-04: `database.sql` L125-134（events_categoriesテーブル）
- E-05: `database.sql` L140-155（events_venuesテーブル）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` L49（画面一覧情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/events/manage/` | E-01 L117, E-02 | ○ |
| C-02 | GETパラメータ category, venue, page | E-01 L133-134, L137-141 | ○ |
| C-03 | 権限チェック eevents | E-01 L125 | ○ |
| C-04 | eeventnew権限でNew Eventボタン表示制御 | E-02 L62 | ○ |
| C-05 | ecategorynew権限でNew Categoryボタン表示制御 | E-02 L63 | ○ |
| C-06 | evenuenew権限でNew Venueボタン表示制御 | E-02 L64 | ○ |
| C-07 | カテゴリ別フィルタ | E-01 L154-161, E-02 L90-102 | ○ |
| C-08 | 会場別フィルタ | E-01 L162-169, E-02 L105-126 | ○ |
| C-09 | カテゴリと会場の複合フィルタ | E-01 L144-153 | ○ |
| C-10 | ページネーション15件/ページ | E-01 L182 | ○ |
| C-11 | ページネーション表示範囲5ページ | E-01 L183 | ○ |
| C-12 | イベント一覧は開始日でDESCソート | E-01 L153, L161, L169, L176 | ○ |
| C-13 | eeventdelete権限でイベント削除リンク | E-02 L155 | ○ |
| C-14 | eventsテーブルの構造 | E-03 | ○ |
| C-15 | events_categoriesテーブルの構造 | E-04 | ○ |
| C-16 | events_venuesテーブルの構造 | E-05 | ○ |
| C-17 | ダイアログ表示にgetDialog関数使用 | E-02 L62, L63, L64, L155 | ○ |
| C-18 | 会場表示形式（会場名+市区町村） | E-01 L66-76 | ○ |
| C-19 | デフォルト会場（venue_id=1）の特別処理 | E-01 L66-76 | ○ |
| C-20 | EDate関数による日時フォーマット | E-01 L20-46 | ○ |
| C-21 | Dojoウィジェット使用 | E-02 L8-21 | ○ |
| C-22 | 権限なし時のprivileges画面転送 | E-01 L190-191 | ○ |
| C-23 | カテゴリ/会場の右クリックメニュー | E-02 L93-98, L109-119 | ○ |
| C-24 | EVenueCount/ECategoryCount View Helper | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EVenueCount/ECategoryCount View Helperの具体的な実装ファイルは未確認
  - 候補：application/modules/admin/views/helpers/ 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は高い

## 6) レビュアーチェックリスト（最小）
- [ ] ページネーション設定（15件/ページ、5ページ範囲）が業務要件と一致するか確認
- [ ] 権限制御（eevents, eeventnew, ecategorynew, evenuenew, eeventdelete）の妥当性確認
- [ ] デフォルト会場（venue_id=1）の用途と表示仕様が要件と一致するか確認
- [ ] EDate関数による日時表示フォーマットが業務要件と一致するか確認
