---
generated_at: 2026-02-11 11:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：49-イベント編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **TinyMCE設定の詳細**：外部ライブラリの設定ファイルは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/EventsController.php` L625-658（editAction）
- E-02: `application/modules/admin/controllers/EventsController.php` L257-444（saveAction）
- E-03: `application/modules/admin/controllers/EventsController.php` L449-620（publishAction）
- E-04: `application/modules/admin/views/scripts/events/edit.phtml` L1-220（ビューテンプレート全体）
- E-05: `application/modules/admin/views/scripts/events/details.phtml` L1-42（詳細ビュー）
- E-06: `database.sql` L103-119（eventsテーブル）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` L50（画面一覧情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/events/edit/id/{event_id}/` | E-01 L631, E-04 | ○ |
| C-02 | 権限チェック eevents, eeventedit | E-01 L627 | ○ |
| C-03 | 保存時の権限チェック eevents, eeventedit | E-02 L259 | ○ |
| C-04 | 公開時の権限チェック eevents, eeventpublish | E-03 L451 | ○ |
| C-05 | eeventedit権限でSaveボタン表示制御 | E-05 L24 | ○ |
| C-06 | eeventpublish権限でPublishボタン表示制御 | E-05 L25-27 | ○ |
| C-07 | eeventdelete権限でDeleteボタン表示制御 | E-05 L29-31 | ○ |
| C-08 | Eventタブのフィールド構成 | E-04 L51-218 | ○ |
| C-09 | saveActionのバリデーションルール | E-02 L287-332 | ○ |
| C-10 | publishActionのバリデーションルール | E-03 L481-516 | ○ |
| C-11 | eventsテーブル更新処理（save） | E-02 L347-359 | ○ |
| C-12 | eventsテーブル更新処理（publish） | E-03 L530-544 | ○ |
| C-13 | 検索インデックス更新（公開済み） | E-02 L376-401 | ○ |
| C-14 | 検索インデックス追加（公開時） | E-03 L573-580 | ○ |
| C-15 | 成功メッセージ「Event Saved」 | E-02 L405-411 | ○ |
| C-16 | 成功メッセージ「Event Published」 | E-03 L582-588 | ○ |
| C-17 | エラーメッセージ各種 | E-02 L288-331 | ○ |
| C-18 | details.phtmlの非同期読み込み | E-04 L43 | ○ |
| C-19 | イベント不存在時のリダイレクト | E-01 L648-650 | ○ |
| C-20 | 日付時刻の結合処理 | E-02 L342-344 | ○ |
| C-21 | コメント設定のY/N変換 | E-02 L270-281 | ○ |
| C-22 | 終了日時は任意 | E-02 L323-324 | ○ |
| C-23 | html_entity_decode処理 | E-02 L353 | ○ |
| C-24 | event_user更新（編集者） | E-02 L354 | ○ |
| C-25 | Dojoウィジェット使用 | E-04 L8-26 | ○ |
| C-26 | TinyMCE設定詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TinyMCE（WYSIWYGエディタ）の詳細設定ファイルは未確認
  - 候補：public/_scripts/admin/tinymce/ 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は高い
- 1: 中リスク - event_user（編集者）が上書きされる仕様の妥当性

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルール（必須/任意、形式）が業務要件と一致するか確認
- [ ] 検索インデックス更新のタイミングと内容が適切か確認
- [ ] event_user（編集者）が上書きされる仕様が要件と一致するか確認
- [ ] 終了日時が任意である仕様が業務要件と一致するか確認
- [ ] TinyMCEの設定（利用可能な機能）が要件と一致するか確認
