---
generated_at: 2026-02-11 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **site.iniのsite.key設定**：パスワードハッシュ用キーの設定ファイル未確認
  2. **Cookie設定のドメイン**：site.cookieの設定未確認
  3. **セキュリティ観点**：MD5ハッシュの安全性評価

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/AuthController.php` (loginAction: 54-158行目, preDispatch: 20-35行目)
- E-02: `application/modules/default/views/scripts/auth/login.phtml` (全体)
- E-03: `database.sql` (users: 347-361行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (No.5行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面No=5の行)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (フロントエンド画面遷移図)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loginActionがエントリーポイント | E-01 (54行目) | ○ |
| C-02 | preDispatchで認証済みユーザーをホームへリダイレクト | E-01 (22-27行目) | ○ |
| C-03 | $_SESSION['curPage']からreferPage取得 | E-01 (57-61行目) | ○ |
| C-04 | POSTリクエスト判定 | E-01 (67行目: isPost()) | ○ |
| C-05 | メールアドレスバリデーション | E-01 (78-86行目) | ○ |
| C-06 | パスワード4文字以上バリデーション | E-01 (87-95行目: StringLength, 4) | ○ |
| C-07 | Zend_Auth_Adapter_DbTable使用 | E-01 (105-111行目) | ○ |
| C-08 | MD5(site.key + password + salt)でハッシュ | E-01 (110行目) | ○ |
| C-09 | user_status='active'条件追加 | E-01 (115行目) | ○ |
| C-10 | 認証成功時セッション保存 | E-01 (125行目: getStorage()->write()) | ○ |
| C-11 | Remember me時Cookie設定（約3ヶ月） | E-01 (127-128行目: 7889231秒) | ○ |
| C-12 | Remember me無効時Cookie削除 | E-01 (130-131行目: time()-60) | ○ |
| C-13 | 認証成功時referPageへリダイレクト | E-01 (133-134行目) | ○ |
| C-14 | FAILURE_IDENTITY_NOT_FOUNDエラー処理 | E-01 (137-138行目) | ○ |
| C-15 | FAILURE_CREDENTIAL_INVALIDエラー処理 | E-01 (139-140行目) | ○ |
| C-16 | method='activated'時のメッセージ表示 | E-02 (32-34行目) | ○ |
| C-17 | Cookie保存済み時のフォーム値プリセット | E-02 (40-67行目) | ○ |
| C-18 | RenderMessages()でエラー表示 | E-02 (30行目) | ○ |
| C-19 | パスワードリセットへのリンク | E-02 (70, 102行目) | ○ |
| C-20 | site.iniのsite.key設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- site.iniの設定内容
  - 候補：`application/configs/site.ini`
  - 確認項目：site.key（パスワードハッシュ用）、site.cookie（Cookieドメイン）
- noaccountbox.phtmlの実装詳細
  - 候補：`application/modules/default/views/scripts/_partials/noaccountbox.phtml`

## 5) リスクフラグ（レビュー観点）
- 0: 認証ロジック（低リスク - コード確認済み）
- 0: バリデーション（低リスク - コード確認済み）
- 1: パスワードハッシュ設定（中リスク - site.key未確認）
- 2: セキュリティ（高リスク - MD5ハッシュの安全性評価必要）
- 0: リダイレクト処理（低リスク - コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] loginActionの認証フローが設計書と一致するか確認
- [ ] site.iniのsite.key設定を確認
- [ ] Cookieドメイン設定を確認
- [ ] MD5ハッシュのセキュリティ評価（より安全なハッシュアルゴリズムへの移行検討）
- [ ] Remember me機能のCookie有効期限が適切か確認
- [ ] エラーメッセージが認証失敗の詳細を漏らさないか確認
