---
generated_at: 2026-02-11 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-イベント新規作成画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/EventsController.php` L696-757（newAction）
- E-02: `application/modules/admin/controllers/EventsController.php` L762-877（new2Action）
- E-03: `application/modules/admin/views/scripts/events/new.phtml` L1-77（Step1ビュー）
- E-04: `application/modules/admin/views/scripts/events/new2.phtml` L1-98（Step2ビュー）
- E-05: `database.sql` L103-119（eventsテーブル）
- E-06: `database.sql` L125-134（events_categoriesテーブル）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` L51（画面一覧情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/admin/events/new/`（Step1） | E-01, E-03 | ○ |
| C-02 | URL `/admin/events/new2/`（Step2） | E-02, E-04 | ○ |
| C-03 | 権限チェック eevents, eeventnew | E-01 L698, E-02 L764 | ○ |
| C-04 | Ajaxダイアログとして表示 | E-01 L699, E-02 L765（disableLayout） | ○ |
| C-05 | Step1 POSTパラメータとバリデーション | E-01 L707-718 | ○ |
| C-06 | Step1成功時のStep2へのリダイレクト | E-01 L724-731 | ○ |
| C-07 | Step2 GETパラメータ（category, venue） | E-02 L767-769 | ○ |
| C-08 | Step2 POSTパラメータとバリデーション | E-02 L777-803 | ○ |
| C-09 | カテゴリ情報取得（ecat_venue, ecat_default） | E-02 L812-820 | ○ |
| C-10 | venue=0時のデフォルト会場使用 | E-02 L826-830 | ○ |
| C-11 | 終了日時の自動計算（開始+2時間） | E-02 L822-824 | ○ |
| C-12 | eventsテーブルINSERT | E-02 L833-841 | ○ |
| C-13 | event_description = ecat_default | E-02 L837 | ○ |
| C-14 | 成功メッセージ「Event Created」 | E-02 L846 | ○ |
| C-15 | Continueボタンでイベント編集画面へ遷移 | E-02 L848-851 | ○ |
| C-16 | エラー時フォーム再表示・値保持 | E-01 L735-742, E-02 L854-862 | ○ |
| C-17 | Step1フォームのVenue FilteringSelect | E-03 L15-34 | ○ |
| C-18 | Step1フォームのCategory FilteringSelect | E-03 L36-55 | ○ |
| C-19 | Step2フォームのName入力 | E-04 L19-36 | ○ |
| C-20 | Step2フォームの日付ピッカー | E-04 L38-55 | ○ |
| C-21 | Step2フォームの時刻ピッカー | E-04 L57-74 | ○ |
| C-22 | Cancelボタン（両Step） | E-03 L62-63, E-04 L83-84 | ○ |
| C-23 | Continueボタン（Step1） | E-03 L59-60 | ○ |
| C-24 | Createボタン（Step2） | E-04 L80-81 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体の信頼度は完全

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリのデフォルト会場（ecat_venue）が適切に設定されているか確認
- [ ] カテゴリのデフォルト説明文（ecat_default）が適切に設定されているか確認
- [ ] 終了日時の自動計算（開始+2時間）が業務要件と一致するか確認
- [ ] 作成されるイベントがdraft状態であることが要件と一致するか確認
- [ ] Default Venue（venue=0）の運用ルールが明確か確認
