---
generated_at: 2026-02-11 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-イベント詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **コメント表示機能の実装有無**：画面機能マッピングに記載があるが、詳細ビューでは直接確認できず
  2. **タグ表示機能の実装有無**：画面機能マッピングに記載があるが、詳細ビューでは直接確認できず
  3. **FCKeditor連携の詳細動作**：JavaScript関数の実装詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/events/details.phtml` (1-39行目)
- E-02: `application/modules/admin/controllers/EventsController.php` (663-691行目 detailsAction)
- E-03: `application/modules/admin/controllers/EventsController.php` (199-252行目 deleteAction)
- E-04: `application/modules/admin/controllers/EventsController.php` (257-444行目 saveAction)
- E-05: `application/modules/admin/controllers/EventsController.php` (449-620行目 publishAction)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (51行目)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (113-115行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/events/details | E-01, E-02 | ○ |
| C-02 | イベントIDをパラメータidで受け取る | E-02 (669行目) | ○ |
| C-03 | 著者名はuser_aliasから取得 | E-01 (15行目), E-02 (678行目) | ○ |
| C-04 | ステータスはevent_statusから取得しucwordsで表示 | E-01 (16行目) | ○ |
| C-05 | Publishボタンは未公開かつeeventpublish権限で表示 | E-01 (26行目) | ○ |
| C-06 | Saveボタンは常に表示される | E-01 (29行目) | ○ |
| C-07 | Deleteボタンはeeventdelete権限で表示 | E-01 (30行目) | ○ |
| C-08 | Events...ボタンで/admin/events/に遷移 | E-01 (31行目) | ○ |
| C-09 | 画面アクセスにはeeventsとeeventedit権限が必要 | E-02 (665行目) | ○ |
| C-10 | 権限不足時はprivilegesにフォワード | E-02 (688行目) | ○ |
| C-11 | レイアウトはdisableLayout()で無効化 | E-02 (667行目) | ○ |
| C-12 | eventsとusersテーブルをJOINして取得 | E-02 (675-679行目) | ○ |
| C-13 | 削除時にコメントも削除される | E-03 (220行目) | ○ |
| C-14 | 削除時に検索インデックスも削除される | E-03 (223行目) | ○ |
| C-15 | 保存時にバリデーションを実行 | E-04 (287-332行目) | ○ |
| C-16 | 公開時に検索インデックスに追加 | E-05 (573-580行目) | ○ |
| C-17 | コメント一覧表示機能が関連 | E-07 (114行目) | △ |
| C-18 | タグ一覧表示機能が関連 | E-07 (115行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17（コメント一覧表示）について：画面機能マッピングには記載があるが、details.phtmlでは直接コメント表示のコードが見当たらない。これはedit.phtml（親画面）側で実装されている可能性がある。
  - 候補：edit.phtml / 別タブでのコメント表示 / Ajax読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL、パラメータ、権限チェックの実装
- 0: 低リスク - ボタン表示条件の実装
- 1: 中リスク - コメント・タグ表示の実装場所の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] details.phtmlの表示内容がeventArrayの構造と一致しているか確認
- [ ] 各ボタンのonClick処理が正しいURLを呼び出しているか確認
- [ ] コメント表示機能の実装場所を確認（edit.phtmlまたは別タブ）
- [ ] ACL権限名（eeventpublish, eeventdelete等）が実際のシステム設定と一致しているか確認
