---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-会場管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり
  2. フィルタ機能の動作確認
  3. ページネーションの動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/scripts/events/venues.phtml` (1-96行目)
- E-02: `application/modules/admin/controllers/EventsController.php` (1318-1379行目 venuesAction)
- E-03: `application/modules/admin/controllers/EventsController.php` (1453-1519行目 venuedeleteAction)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (56行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (123-124行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/events/venues | E-02 (venuesAction) | ○ |
| C-02 | 画面アクセスにはeevents権限が必要 | E-02 (1320行目) | ○ |
| C-03 | フィルタパラメータはcityとcountry | E-02 (1327-1329行目) | ○ |
| C-04 | デフォルト会場（ID=1）は除外 | E-02 (1341行目、1347行目、1354行目、1360行目) | ○ |
| C-05 | 15件/ページでページネーション | E-02 (1367行目) | ○ |
| C-06 | ページ範囲は5 | E-02 (1368行目) | ○ |
| C-07 | New Venueボタンはevenuenew権限で表示 | E-01 (40行目) | ○ |
| C-08 | Deleteリンクはevenuedelete権限で表示 | E-01 (73行目) | ○ |
| C-09 | フィルタ未適用時は「No active filter」表示 | E-01 (53行目) | ○ |
| C-10 | 会場が存在しない場合は「No Venues!」表示 | E-01 (82行目) | ○ |
| C-11 | 会場名リンクで編集画面に遷移 | E-01 (72行目) | ○ |
| C-12 | 都市リンクでフィルタリング | E-01 (75行目) | ○ |
| C-13 | 国リンクでフィルタリング | E-01 (76行目) | ○ |
| C-14 | フィルタタグクリックで解除 | E-01 (51-52行目 onClick goTo) | ○ |
| C-15 | 会場一覧はタイトル順でソート | E-02 (1344行目、1350行目、1356行目、1361行目 ORDER BY venue_title ASC) | ○ |
| C-16 | 権限不足時はprivilegesにフォワード | E-02 (1375行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 会場一覧表示の実装
- 0: 低リスク - 権限チェックの実装
- 0: 低リスク - フィルタ機能の実装

## 6) レビュアーチェックリスト（最小）
- [ ] venues.phtmlの表示内容がvenuesArrayの構造と一致しているか確認
- [ ] フィルタ（city、country）が正しく動作するか確認
- [ ] フィルタ解除（タグクリック）が正しく動作するか確認
- [ ] デフォルト会場（ID=1）が一覧から除外されているか確認
- [ ] ページネーションが正しく動作するか確認
